/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.OutlineStepSubstitution;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class GherkinPsiUtil {
    private GherkinPsiUtil() {
    }

    @Nullable
    public static GherkinFileImpl getGherkinFile(@NotNull PsiElement element) {
        if (element == null) {
            GherkinPsiUtil.$$$reportNull$$$0(0);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        return containingFile instanceof GherkinFileImpl ? (GherkinFileImpl)containingFile : null;
    }

    @Nullable
    public static List<TextRange> buildParameterRanges(@NotNull GherkinStep step, @NotNull AbstractStepDefinition definition, int shiftOffset) {
        if (step == null) {
            GherkinPsiUtil.$$$reportNull$$$0(1);
        }
        if (definition == null) {
            GherkinPsiUtil.$$$reportNull$$$0(2);
        }
        OutlineStepSubstitution substitution = GherkinPsiUtil.convertOutlineStepName(step);
        ArrayList<TextRange> parameterRanges = new ArrayList<TextRange>();
        Pattern pattern = definition.getPattern();
        if (pattern == null) {
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.contains(substitution.getSubstitution(), pattern)) {
            MatchResult match = matcher.getMatch();
            int groupCount = match.groups();
            for (int i = 1; i < groupCount; ++i) {
                int start = match.beginOffset(i);
                int end = match.endOffset(i);
                if (start < 0 || end < 0) continue;
                int rangeStart = substitution.getOffsetInOutlineStep(start);
                int rangeEnd = substitution.getOffsetInOutlineStep(end);
                parameterRanges.add(new TextRange(rangeStart, rangeEnd).shiftRight(shiftOffset));
            }
        }
        int k = step.getText().indexOf(step.getStepName());
        if ((k += step.getStepName().length()) < step.getText().length() - 1) {
            String text = step.getText().substring(k + 1);
            boolean inParam = false;
            int paramStart = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == '<') {
                    paramStart = i;
                    inParam = true;
                }
                if (text.charAt(i) != '>' || !inParam) continue;
                parameterRanges.add(new TextRange(paramStart, i + 1).shiftRight(shiftOffset + step.getStepName().length() + 1));
                inParam = false;
            }
        }
        return parameterRanges;
    }

    public static OutlineStepSubstitution convertOutlineStepName(@NotNull GherkinStep step) {
        if (step == null) {
            GherkinPsiUtil.$$$reportNull$$$0(3);
        }
        if (!(step.getStepHolder() instanceof GherkinScenarioOutline)) {
            return new OutlineStepSubstitution(step.getName());
        }
        Map<String, String> outlineTableMap = ((GherkinScenarioOutline)step.getStepHolder()).getOutlineTableMap();
        return CucumberUtil.substituteTableReferences(step.getStepName(), outlineTableMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/GherkinPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGherkinFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildParameterRanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convertOutlineStepName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

