/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinLexer;
import org.jetbrains.plugins.cucumber.psi.GherkinParser;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCellImpl;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureHeaderImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPystringImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepParameterImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTagImpl;

public class GherkinParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITESPACE = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        GherkinLexer gherkinLexer = new GherkinLexer(JsonGherkinKeywordProvider.getKeywordProvider());
        if (gherkinLexer == null) {
            GherkinParserDefinition.$$$reportNull$$$0(0);
        }
        return gherkinLexer;
    }

    public PsiParser createParser(Project project) {
        return new GherkinParser();
    }

    public IFileElementType getFileNodeType() {
        return GherkinElementTypes.GHERKIN_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITESPACE;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENTS;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() == GherkinElementTypes.FEATURE) {
            GherkinFeatureImpl gherkinFeatureImpl = new GherkinFeatureImpl(node);
            if (gherkinFeatureImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(4);
            }
            return gherkinFeatureImpl;
        }
        if (node.getElementType() == GherkinElementTypes.FEATURE_HEADER) {
            GherkinFeatureHeaderImpl gherkinFeatureHeaderImpl = new GherkinFeatureHeaderImpl(node);
            if (gherkinFeatureHeaderImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(5);
            }
            return gherkinFeatureHeaderImpl;
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO) {
            GherkinScenarioImpl gherkinScenarioImpl = new GherkinScenarioImpl(node);
            if (gherkinScenarioImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(6);
            }
            return gherkinScenarioImpl;
        }
        if (node.getElementType() == GherkinElementTypes.STEP) {
            GherkinStepImpl gherkinStepImpl = new GherkinStepImpl(node);
            if (gherkinStepImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(7);
            }
            return gherkinStepImpl;
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO_OUTLINE) {
            GherkinScenarioOutlineImpl gherkinScenarioOutlineImpl = new GherkinScenarioOutlineImpl(node);
            if (gherkinScenarioOutlineImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(8);
            }
            return gherkinScenarioOutlineImpl;
        }
        if (node.getElementType() == GherkinElementTypes.EXAMPLES_BLOCK) {
            GherkinExamplesBlockImpl gherkinExamplesBlockImpl = new GherkinExamplesBlockImpl(node);
            if (gherkinExamplesBlockImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(9);
            }
            return gherkinExamplesBlockImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE) {
            GherkinTableImpl gherkinTableImpl = new GherkinTableImpl(node);
            if (gherkinTableImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(10);
            }
            return gherkinTableImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_ROW) {
            GherkinTableRowImpl gherkinTableRowImpl = new GherkinTableRowImpl(node);
            if (gherkinTableRowImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(11);
            }
            return gherkinTableRowImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_CELL) {
            GherkinTableCellImpl gherkinTableCellImpl = new GherkinTableCellImpl(node);
            if (gherkinTableCellImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(12);
            }
            return gherkinTableCellImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_HEADER_ROW) {
            GherkinTableHeaderRowImpl gherkinTableHeaderRowImpl = new GherkinTableHeaderRowImpl(node);
            if (gherkinTableHeaderRowImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(13);
            }
            return gherkinTableHeaderRowImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TAG) {
            GherkinTagImpl gherkinTagImpl = new GherkinTagImpl(node);
            if (gherkinTagImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(14);
            }
            return gherkinTagImpl;
        }
        if (node.getElementType() == GherkinElementTypes.STEP_PARAMETER) {
            GherkinStepParameterImpl gherkinStepParameterImpl = new GherkinStepParameterImpl(node);
            if (gherkinStepParameterImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(15);
            }
            return gherkinStepParameterImpl;
        }
        if (node.getElementType() == GherkinElementTypes.PYSTRING) {
            GherkinPystringImpl gherkinPystringImpl = new GherkinPystringImpl(node);
            if (gherkinPystringImpl == null) {
                GherkinParserDefinition.$$$reportNull$$$0(16);
            }
            return gherkinPystringImpl;
        }
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            GherkinParserDefinition.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new GherkinFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        IElementType leftElementType = left.getElementType();
        if (leftElementType == GherkinTokenTypes.COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (right.getElementType() == GherkinTokenTypes.EXAMPLES_KEYWORD) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

