/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;

public class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static JSStatement stripBraces(JSStatement branch) {
        if (branch != null && branch instanceof JSBlockStatement) {
            JSBlockStatement block = (JSBlockStatement)branch;
            JSStatement[] statements = block.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean isReturn(JSStatement statement, String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof JSReturnStatement)) {
            return false;
        }
        JSExpression returnExpression = ((JSReturnStatement)statement).getExpression();
        return returnExpression != null && value.equals(returnExpression.getText());
    }

    public static boolean isAssignment(JSStatement statement, String value) {
        if (statement == null || !(statement instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpression expression = ((JSExpressionStatement)statement).getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return false;
        }
        JSExpression rhs = ((JSAssignmentExpression)expression).getROperand();
        return rhs != null && rhs.getText().equals(value);
    }

    public static boolean isAssignment(JSStatement statement) {
        if (!(statement instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
        return expressionStatement.getExpression() instanceof JSAssignmentExpression;
    }

    public static boolean isConditional(JSExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses((JSExpression)expression)) == null) {
            return false;
        }
        if (expression instanceof JSConditionalExpression) {
            return true;
        }
        if (expression instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType sign = binaryExpression.getOperationSign();
            if (JSTokenTypes.XOR.equals(sign)) {
                return ConditionalUtils.isConditional(binaryExpression.getLOperand()) && ConditionalUtils.isConditional(binaryExpression.getROperand());
            }
            return JSTokenTypes.ANDAND.equals(sign) || JSTokenTypes.OROR.equals(sign) || JSTokenTypes.EQ.equals(sign) || JSTokenTypes.NE.equals(sign) || JSTokenTypes.LT.equals(sign) || JSTokenTypes.LE.equals(sign) || JSTokenTypes.GT.equals(sign) || JSTokenTypes.GE.equals(sign);
        }
        return BoolUtils.isBooleanLiteral(expression);
    }

    public static boolean isSimplifiableImplicitReturn(JSIfStatement ifStatement, boolean negated) {
        JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
        PsiElement nextStatement = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)ifStatement, true);
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        if (negated) {
            return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
        }
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableReturn(JSIfStatement ifStatement, boolean negated) {
        JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
        JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
        if (negated) {
            return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
        }
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableAssignment(JSIfStatement ifStatement, boolean negated) {
        boolean isAssignment;
        JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
        JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
        if (negated) {
            isAssignment = ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true");
        } else {
            boolean bl = isAssignment = ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false");
        }
        if (isAssignment) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)thenLhs, (JSExpression)elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignment(JSIfStatement ifStatement, boolean negated) {
        boolean isAssignment;
        if (ifStatement.getElse() != null) {
            return false;
        }
        JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
        PsiElement nextStatement = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)ifStatement, false);
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = ConditionalUtils.stripBraces((JSStatement)nextStatement);
        if (negated) {
            isAssignment = ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true");
        } else {
            boolean bl = isAssignment = ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false");
        }
        if (isAssignment) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)thenLhs, (JSExpression)elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableEmptyBranches(JSIfStatement ifStatement) {
        JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
        JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
        if (elseBranch == null) {
            return false;
        }
        return thenBranch instanceof JSEmptyStatement || thenBranch instanceof JSBlockStatement && ((JSBlockStatement)thenBranch).getStatements().length == 0 || elseBranch instanceof JSEmptyStatement || elseBranch instanceof JSBlockStatement && ((JSBlockStatement)elseBranch).getStatements().length == 0;
    }

    public static void replaceSimplifiableImplicitReturn(JSIfStatement statement, boolean negated) throws IncorrectOperationException {
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : condition.getText();
        JSElement nextStatement = (JSElement)JSElementFactory.getNonWhiteSpaceSibling((PsiElement)statement, true);
        String newStatement = "return " + conditionText + ';';
        com.intellij.lang.javascript.psi.JSElementFactory.replaceStatement((JSStatement)statement, (String)newStatement);
        assert (nextStatement != null);
        com.intellij.lang.javascript.psi.JSElementFactory.removeElement((PsiElement)nextStatement);
    }

    public static void replaceSimplifiableReturn(JSIfStatement statement, boolean negated) {
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : com.sixrr.inspectjs.utils.ConditionalUtils.castToBoolean((JSExpression)condition);
        String newStatement = "return " + conditionText + ';';
        com.intellij.lang.javascript.psi.JSElementFactory.replaceStatement((JSStatement)statement, (String)newStatement);
    }

    public static void replaceSimplifiableAssignment(JSIfStatement statement, boolean negated) throws IncorrectOperationException {
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : condition.getText();
        JSExpressionStatement assignmentStatement = (JSExpressionStatement)ConditionalUtils.stripBraces(statement.getThen());
        JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
        IElementType operator = assignmentExpression.getOperationSign();
        String operand = BinaryOperatorUtils.getOperatorText((IElementType)operator);
        JSExpression lhs = assignmentExpression.getLOperand();
        String lhsText = lhs.getText();
        com.intellij.lang.javascript.psi.JSElementFactory.replaceStatement((JSStatement)statement, (String)(lhsText + operand + conditionText + ';'));
    }

    public static void replaceSimplifiableImplicitAssignment(JSIfStatement statement, boolean negated) throws IncorrectOperationException {
        JSElement prevStatement = (JSElement)JSElementFactory.getNonWhiteSpaceSibling((PsiElement)statement, false);
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : condition.getText();
        JSExpressionStatement assignmentStatement = (JSExpressionStatement)ConditionalUtils.stripBraces(statement.getThen());
        JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
        IElementType operator = assignmentExpression.getOperationSign();
        String operand = BinaryOperatorUtils.getOperatorText((IElementType)operator);
        JSExpression lhs = assignmentExpression.getLOperand();
        String lhsText = lhs.getText();
        com.intellij.lang.javascript.psi.JSElementFactory.replaceStatement((JSStatement)statement, (String)(lhsText + operand + conditionText + ';'));
        assert (prevStatement != null);
        com.intellij.lang.javascript.psi.JSElementFactory.removeElement((PsiElement)prevStatement);
    }

    private static void replaceSimplifiableEmptyBranch(JSIfStatement ifStatement) {
        String bodyText;
        String conditionText;
        JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
        JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
        assert (elseBranch != null) : "Condition worked unexpectedly for " + ifStatement.getText();
        if (thenBranch instanceof JSEmptyStatement || thenBranch instanceof JSBlockStatement && ((JSBlockStatement)thenBranch).getStatements().length == 0) {
            conditionText = BoolUtils.getNegatedExpressionText(ifStatement.getCondition());
            bodyText = elseBranch.getText();
        } else if (elseBranch instanceof JSEmptyStatement || elseBranch instanceof JSBlockStatement && ((JSBlockStatement)elseBranch).getStatements().length == 0) {
            conditionText = ifStatement.getCondition().getText();
            bodyText = thenBranch.getText();
        } else {
            assert (false) : "Condition worked unexpectedly for " + ifStatement.getText();
            return;
        }
        com.intellij.lang.javascript.psi.JSElementFactory.replaceStatement((JSStatement)ifStatement, (String)("if (" + conditionText + ") " + bodyText + ';'));
    }

    public static void replaceAssignmentOrReturnIfSimplifiable(JSIfStatement statement) throws IncorrectOperationException {
        if (ConditionalUtils.isSimplifiableAssignment(statement, false)) {
            ConditionalUtils.replaceSimplifiableAssignment(statement, false);
        } else if (ConditionalUtils.isSimplifiableAssignment(statement, true)) {
            ConditionalUtils.replaceSimplifiableAssignment(statement, true);
        } else if (ConditionalUtils.isSimplifiableReturn(statement, false)) {
            ConditionalUtils.replaceSimplifiableReturn(statement, false);
        } else if (ConditionalUtils.isSimplifiableReturn(statement, true)) {
            ConditionalUtils.replaceSimplifiableReturn(statement, true);
        } else if (ConditionalUtils.isSimplifiableImplicitReturn(statement, false)) {
            ConditionalUtils.replaceSimplifiableImplicitReturn(statement, false);
        } else if (ConditionalUtils.isSimplifiableImplicitReturn(statement, true)) {
            ConditionalUtils.replaceSimplifiableImplicitReturn(statement, true);
        } else if (ConditionalUtils.isSimplifiableImplicitAssignment(statement, false)) {
            ConditionalUtils.replaceSimplifiableImplicitAssignment(statement, false);
        } else if (ConditionalUtils.isSimplifiableImplicitAssignment(statement, true)) {
            ConditionalUtils.replaceSimplifiableImplicitAssignment(statement, true);
        } else if (ConditionalUtils.isSimplifiableEmptyBranches(statement)) {
            ConditionalUtils.replaceSimplifiableEmptyBranch(statement);
        }
    }

    public static void replaceConditionalWithIf(JSConditionalExpression conditional) throws IncorrectOperationException {
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)conditional, JSStatement.class);
        assert (statement != null);
        String statementText = statement.getText();
        String conditionalText = ParenthesesUtils.unstripParentheses((JSExpression)conditional).getText();
        int conditionalIndex = statementText.indexOf(conditionalText);
        String statementStart = statementText.substring(0, conditionalIndex);
        String statementEnd = statementText.substring(conditionalIndex + conditionalText.length());
        JSExpression condition = ParenthesesUtils.stripParentheses((JSExpression)conditional.getCondition());
        JSExpression thenExpression = ParenthesesUtils.stripParentheses((JSExpression)conditional.getThen());
        JSExpression elseExpression = ParenthesesUtils.stripParentheses((JSExpression)conditional.getElse());
        String ifStatementText = "if (" + condition.getText() + ") {" + statementStart + thenExpression.getText() + statementEnd + "} else {" + statementStart + elseExpression.getText() + statementEnd + '}';
        com.intellij.lang.javascript.psi.JSElementFactory.replaceStatement((JSStatement)statement, (String)ifStatementText);
    }
}

