/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSRemoveRedundantElseIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        RemoveRedundantElsePredicate removeRedundantElsePredicate = new RemoveRedundantElsePredicate();
        if (removeRedundantElsePredicate == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(0);
        }
        return removeRedundantElsePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSRemoveRedundantElseIntention.$$$reportNull$$$0(1);
        }
        JSIfStatement ifStatement = (JSIfStatement)element;
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        assert (thenBranch != null);
        assert (elseBranch != null);
        String newIfText = IF_STATEMENT_PREFIX + ifStatement.getCondition().getText() + ')' + thenBranch.getText();
        String elseText = elseBranch.getText();
        String newStatement = elseBranch instanceof JSBlockStatement ? elseText.substring(elseText.indexOf(123) + 1, elseText.lastIndexOf(125) - 1).trim() : elseText;
        JSIfStatement newIfStatement = (JSIfStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)newIfText, (PsiElement)element, JSIfStatement.class);
        assert (newIfStatement != null) : newIfText;
        ifStatement = (JSIfStatement)ifStatement.replace((JSStatement)newIfStatement);
        JSElementFactory.reformat((PsiElement)ifStatement);
        JSElementFactory.addStatementsAfter((JSStatement)ifStatement, (String)newStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveRedundantElsePredicate
    implements JSElementPredicate {
        private RemoveRedundantElsePredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                RemoveRedundantElsePredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)element;
            if (ErrorUtil.containsError((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement elseBranch = ifStatement.getElse();
            JSStatement thenBranch = ifStatement.getThen();
            if (elseBranch == null) {
                return false;
            }
            while (thenBranch != null && thenBranch instanceof JSBlockStatement) {
                Object[] thenStatements = ((JSBlockStatement)thenBranch).getStatements();
                JSStatement lastStatement = (JSStatement)ArrayUtil.getLastElement((Object[])thenStatements);
                if (lastStatement instanceof JSReturnStatement || lastStatement instanceof JSBreakStatement || lastStatement instanceof JSContinueStatement || lastStatement instanceof JSThrowStatement) {
                    return true;
                }
                thenBranch = lastStatement;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSRemoveRedundantElseIntention$RemoveRedundantElsePredicate", "satisfiedBy"));
        }
    }
}

