/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeIfAndIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MergeIfAndPredicate mergeIfAndPredicate = new MergeIfAndPredicate();
        if (mergeIfAndPredicate == null) {
            JSMergeIfAndIntention.$$$reportNull$$$0(0);
        }
        return mergeIfAndPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSMergeIfAndIntention.$$$reportNull$$$0(1);
        }
        assert (element.getParent() != null);
        assert (element.getParent() instanceof JSIfStatement || element instanceof JSIfStatement);
        JSIfStatement parentStatement = (JSIfStatement)(element.getParent() instanceof JSIfStatement ? element.getParent() : element);
        JSIfStatement childStatement = (JSIfStatement)ConditionalUtils.stripBraces(parentStatement.getThen());
        JSExpression childCondition = childStatement.getCondition();
        JSExpression parentCondition = parentStatement.getCondition();
        String childConditionText = ParenthesesUtils.getParenthesized((JSExpression)childCondition, (int)13);
        String parentConditionText = ParenthesesUtils.getParenthesized((JSExpression)parentCondition, (int)13);
        JSStatement childThenBranch = childStatement.getThen();
        String statement = IF_STATEMENT_PREFIX + parentConditionText + " && " + childConditionText + ')' + childThenBranch.getText();
        JSElementFactory.replaceStatement((JSStatement)parentStatement, (String)statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfAndIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfAndIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MergeIfAndPredicate
    implements JSElementPredicate {
        private MergeIfAndPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            if (element == null) {
                MergeIfAndPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if (ErrorUtil.containsError((PsiElement)(ifStatement = (JSIfStatement)parent))) {
                return false;
            }
            JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
            JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
            if (thenBranch == null || elseBranch != null) {
                return false;
            }
            if (!(thenBranch instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement childIfStatement = (JSIfStatement)thenBranch;
            return childIfStatement.getElse() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfAndIntention$MergeIfAndPredicate", "satisfiedBy"));
        }
    }
}

