/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.keyPath;

import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathArbitraryEntryKeyReference;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathBeanPropertyReference;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathEnumReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigKeyPathReferenceSet {
    @NotNull
    private final PsiElement myElement;
    private final SpringBootApplicationMetaConfigKey myKey;
    private final List<Reference> myReferences;

    public ConfigKeyPathReferenceSet(@NotNull PsiElement element, String text, int offset, SpringBootApplicationMetaConfigKey configKey) {
        if (element == null) {
            ConfigKeyPathReferenceSet.$$$reportNull$$$0(0);
        }
        this.myReferences = new SmartList();
        this.myElement = element;
        this.myKey = configKey;
        assert (this.myKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.INDEXED, SpringBootApplicationMetaConfigKey.AccessType.MAP, SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP)) : configKey;
        this.parse(text, offset);
    }

    private void parse(String text, final int offset) {
        new DelimitedListProcessor("."){
            private int index;
            {
                super(x0);
                this.index = 0;
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                TextRange range = TextRange.create((int)start, (int)end).shiftRight(offset);
                if (ConfigKeyPathReferenceSet.this.myKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.INDEXED)) {
                    this.parseIndexed(range);
                } else {
                    this.parseMap(range);
                }
                ++this.index;
            }

            private void parseIndexed(TextRange range) {
                ConfigKeyPathReferenceSet.this.myReferences.add(new ConfigKeyPathBeanPropertyReference(ConfigKeyPathReferenceSet.this.getElement(), range, ConfigKeyPathReferenceSet.this, this.index));
            }

            private void parseMap(TextRange range) {
                PsiClass previousValueClass;
                if (this.index == 0) {
                    if (ConfigKeyPathReferenceSet.this.isEnumMapKey()) {
                        ConfigKeyPathReferenceSet.this.myReferences.add(new ConfigKeyPathEnumReference(ConfigKeyPathReferenceSet.this.getElement(), range, ConfigKeyPathReferenceSet.this, 0));
                    } else {
                        ConfigKeyPathReferenceSet.this.myReferences.add(new ConfigKeyPathArbitraryEntryKeyReference(ConfigKeyPathReferenceSet.this.getElement(), range, ConfigKeyPathReferenceSet.this, 0));
                    }
                    return;
                }
                Reference previousReference = ConfigKeyPathReferenceSet.this.getReference(this.index - 1);
                PsiClass previousKeyClass = previousReference.getKeyClass();
                if (previousKeyClass != null && previousKeyClass.isEnum() && previousReference instanceof ConfigKeyPathBeanPropertyReference) {
                    ConfigKeyPathReferenceSet.this.myReferences.add(new ConfigKeyPathEnumReference(ConfigKeyPathReferenceSet.this.getElement(), range, ConfigKeyPathReferenceSet.this, this.index));
                    return;
                }
                if (!ConfigKeyPathReferenceSet.this.isEnumMapKey() && (previousValueClass = previousReference.getValueClass()) != null && ConfigKeyPathBeanPropertyReference.stopResolvingProperty(previousValueClass)) {
                    ConfigKeyPathReferenceSet.this.myReferences.add(new ConfigKeyPathArbitraryEntryKeyReference(ConfigKeyPathReferenceSet.this.getElement(), range, ConfigKeyPathReferenceSet.this, this.index));
                    return;
                }
                ConfigKeyPathReferenceSet.this.myReferences.add(new ConfigKeyPathBeanPropertyReference(ConfigKeyPathReferenceSet.this.getElement(), range, ConfigKeyPathReferenceSet.this, this.index));
            }
        }.processText(text);
    }

    private PsiClass getKeyClass() {
        return this.myKey.getMapKeyType();
    }

    @Nullable
    private PsiClass getValueClass() {
        if (this.myKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP)) {
            PsiClassType mapValueType = this.myKey.getMapValueType();
            PsiClass listType = ConfigKeyPathReferenceSet.getTypeParameterClass((PsiType)mapValueType, "java.util.List", 0);
            if (listType != null) {
                return listType;
            }
            return PsiTypesUtil.getPsiClass((PsiType)mapValueType);
        }
        PsiType type = this.myKey.getType();
        assert (type != null);
        PsiType v = ((PsiClassType)type).getParameters()[0];
        return PsiTypesUtil.getPsiClass((PsiType)v);
    }

    @NotNull
    private PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            ConfigKeyPathReferenceSet.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    private Reference getReference(int index) {
        return this.myReferences.get(index);
    }

    private boolean isEnumMapKey() {
        return this.myKey.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.ENUM_MAP);
    }

    public PsiReference[] getReferences() {
        return this.myReferences.toArray(new PsiReference[this.myReferences.size()]);
    }

    @Nullable
    static PsiClass getTypeParameterClass(@Nullable PsiType type, @NotNull String requiredBaseClass, int index) {
        if (requiredBaseClass == null) {
            ConfigKeyPathReferenceSet.$$$reportNull$$$0(2);
        }
        if (type instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)type, (String)requiredBaseClass)) {
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length < index + 1) {
                return null;
            }
            PsiType parameterType = parameters[index];
            return PsiTypesUtil.getPsiClass((PsiType)parameterType);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/keyPath/ConfigKeyPathReferenceSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredBaseClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/keyPath/ConfigKeyPathReferenceSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Reference
    extends PsiReferenceBase<PsiElement> {
        private final ConfigKeyPathReferenceSet myReferenceSet;
        private final int myIndex;

        protected Reference(PsiElement element, TextRange textRange, ConfigKeyPathReferenceSet referenceSet, int index) {
            super(element, textRange);
            this.myReferenceSet = referenceSet;
            this.myIndex = index;
            this.adjustTextRangeForIndexAccess(textRange);
        }

        private void adjustTextRangeForIndexAccess(TextRange textRange) {
            String elementText = this.getValue();
            if (Reference.hasIndexedAccess(elementText)) {
                this.setRangeInElement(TextRange.create((int)0, (int)elementText.indexOf("[")).shiftRight(textRange.getStartOffset()));
            }
        }

        private static boolean hasIndexedAccess(String value) {
            return StringUtil.endsWithChar((CharSequence)value, (char)']') && StringUtil.containsChar((String)value, (char)'[');
        }

        public abstract PathType getPathType();

        @Nullable
        public abstract PsiClass getValueClass();

        protected PsiClass getInitialValueClass() {
            return this.myReferenceSet.getValueClass();
        }

        @Nullable
        public abstract PsiClass getKeyClass();

        protected PsiClass getInitialKeyClass() {
            return this.myReferenceSet.getKeyClass();
        }

        protected boolean isFirst() {
            return this.myIndex == 0;
        }

        protected boolean isLast() {
            return this.myReferenceSet.getReferences().length - 1 == this.myIndex;
        }

        protected Reference getPrevious() {
            return this.myReferenceSet.getReference(this.myIndex - 1);
        }

        protected final char getKeyValueDelimiter() {
            return PropertiesCodeStyleSettings.getInstance((Project)this.getElement().getProject()).getDelimiter();
        }

        protected boolean isEnumMapKey() {
            return this.myReferenceSet.isEnumMapKey();
        }

        public static enum PathType {
            ENUM,
            BEAN_PROPERTY,
            ARBITRARY_ENTRY_KEY;

        }
    }
}

