/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.jam.JamService;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootConfigurationPropertyReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    private static final CachedValueProvider.Result<String> NULL_PREFIX_RESULT = CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});

    protected SpringBootConfigurationPropertyReferenceSearcher() {
        super(true);
    }

    protected boolean processModule(MethodReferencesSearch.SearchParameters queryParameters, String prefix, Module module) {
        return true;
    }

    protected abstract boolean processModelConfigFiles(MethodReferencesSearch.SearchParameters var1, PsiManager var2, String var3, Module var4, SpringBootModelConfigFileContributor var5);

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        SearchScope scope;
        if (queryParameters == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((scope = queryParameters.getEffectiveSearchScope()) instanceof GlobalSearchScope)) {
            return;
        }
        Project project = queryParameters.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project) || !SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            return;
        }
        PsiMethod psiMethod = queryParameters.getMethod();
        String prefix = SpringBootConfigurationPropertyReferenceSearcher.getPrefixIfRelevantPropertyMethod(psiMethod, true);
        if (prefix == null) {
            return;
        }
        Module currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        Set<Module> relevantModules = this.getRelevantModules(project, currentModule);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (Module module : relevantModules) {
            if (!SpringCommonUtils.hasSpringFacet((Module)module) || !SpringBootLibraryUtil.hasSpringBootLibrary(module)) continue;
            if (!this.processModule(queryParameters, prefix, module)) {
                return;
            }
            for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                if (this.processModelConfigFiles(queryParameters, psiManager, prefix, module, contributor)) continue;
                return;
            }
        }
    }

    @Nullable
    public static String getPrefixIfRelevantPropertyMethod(PsiMethod psiMethod, boolean checkIfSetter) {
        if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract")) {
            return null;
        }
        if (checkIfSetter && !PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) {
            return null;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
            if (containingClass.isInterface() || containingClass.hasModifierProperty("abstract") || !SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)containingClass)) {
                return NULL_PREFIX_RESULT;
            }
            ConfigurationProperties configurationProperties = SpringBootConfigurationPropertyReferenceSearcher.findEnclosingOrUsingConfigurationProperties(containingClass);
            if (configurationProperties == null) {
                return NULL_PREFIX_RESULT;
            }
            String prefix = configurationProperties.getValueOrPrefix();
            if (StringUtil.isEmpty((String)prefix)) {
                return NULL_PREFIX_RESULT;
            }
            return CachedValueProvider.Result.create((Object)prefix, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static ConfigurationProperties findEnclosingOrUsingConfigurationProperties(@NotNull PsiClass psiClass) {
        ConfigurationProperties currentClass;
        if (psiClass == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(2);
        }
        if ((currentClass = (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass)) != null) {
            return currentClass;
        }
        if (psiClass.getContainingClass() != null) {
            return (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass.getContainingClass());
        }
        SearchScope classUseScope = psiClass.getUseScope();
        if (!(classUseScope instanceof GlobalSearchScope)) {
            return null;
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        List nestedConfigurationProperties = jamService.getJamFieldElements(NestedConfigurationProperty.FIELD_META, "org.springframework.boot.context.properties.NestedConfigurationProperty", (GlobalSearchScope)classUseScope);
        for (NestedConfigurationProperty property : nestedConfigurationProperties) {
            if (!property.typeMatches(psiClass)) continue;
            return property.getEnclosingConfigurationProperties();
        }
        List beanConfigurationProperties = jamService.getJamMethodElements(ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", (GlobalSearchScope)classUseScope);
        for (ConfigurationProperties.Method configurationProperties : beanConfigurationProperties) {
            if (!configurationProperties.isDefinitionFor(psiClass)) continue;
            return configurationProperties;
        }
        return null;
    }

    protected static boolean searchMetaConfigKeyReferences(@NotNull MethodReferencesSearch.SearchParameters queryParameters, final PsiReference[] references) {
        if (queryParameters == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(3);
        }
        final PsiMethod psiMethod = queryParameters.getMethod();
        final Ref processorResult = Ref.create((Object)Boolean.TRUE);
        ReadActionProcessor<Processor<PsiReference>> customProcessor = new ReadActionProcessor<Processor<PsiReference>>(){

            public boolean processInReadAction(Processor<PsiReference> processor) {
                for (PsiReference reference : references) {
                    if (!(reference instanceof MetaConfigKeyReference)) continue;
                    PsiElement resolve = reference.resolve();
                    if (resolve == null) {
                        return true;
                    }
                    PsiElement navigationElement = resolve.getNavigationElement();
                    if (!(navigationElement instanceof PsiMethod)) {
                        return true;
                    }
                    if (!navigationElement.getManager().areElementsEquivalent(navigationElement, (PsiElement)psiMethod)) {
                        return true;
                    }
                    if (processor.process((Object)reference)) continue;
                    processorResult.set((Object)Boolean.FALSE);
                    return false;
                }
                return true;
            }
        };
        queryParameters.getOptimizer().searchCustom((Processor)customProcessor);
        return (Boolean)processorResult.get();
    }

    @NotNull
    protected Set<Module> getRelevantModules(Project project, @Nullable Module currentModule) {
        LinkedHashSet<Module> relevantModules = new LinkedHashSet<Module>();
        if (currentModule == null) {
            ContainerUtil.addAll(relevantModules, (Object[])ModuleManager.getInstance((Project)project).getModules());
        } else {
            ModuleUtilCore.getDependencies((Module)currentModule, relevantModules);
        }
        LinkedHashSet<Module> linkedHashSet = relevantModules;
        if (linkedHashSet == null) {
            SpringBootConfigurationPropertyReferenceSearcher.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingOrUsingConfigurationProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "searchMetaConfigKeyReferences";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

