/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Interner<T> {
    private final Interner<T> parent;
    private final int firstIndex;
    private final Map<T, Integer> interned = new HashMap<T, Integer>();

    public Interner(Interner<T> parent) {
        this.parent = parent;
        this.firstIndex = parent != null ? parent.interned.size() + parent.firstIndex : 0;
    }

    public Interner() {
        this(null);
    }

    @Nullable
    private Integer find(@NotNull T obj) {
        Integer index;
        assert (this.parent == null || this.parent.interned.size() + this.parent.firstIndex == this.firstIndex) : "Parent changed in parallel with child: indexes will be wrong";
        if (this.parent != null && (index = super.find(obj)) != null) {
            return index;
        }
        return this.interned.get(obj);
    }

    public int intern(@NotNull T obj) {
        Integer index = this.find(obj);
        if (index != null) {
            return index;
        }
        index = this.firstIndex + this.interned.size();
        this.interned.put(obj, index);
        return index;
    }

    @NotNull
    public List<T> getAllInternedObjects() {
        return CollectionsKt.sortedBy(this.interned.keySet(), this.interned::get);
    }

    public boolean isEmpty() {
        return this.interned.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }
}

