/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.collectionUtils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\u001aD\u0010\u0005\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u0006\"\b\b\u0001\u0010\u0002*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u0002H\u0006\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\f\u001aP\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00022\u0006\u0010\u000e\u001a\u0002H\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u000bH\u0086\b\u00a2\u0006\u0002\u0010\u0010\u001aC\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u000bH\u0086\b\u001a.\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a8\u0006\u0013"}, d2={"concatInOrder", "", "T", "c1", "c2", "getFirstClassifierDiscriminateHeaders", "Scope", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "scopes", "", "callback", "Lkotlin/Function1;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getFromAllScopes", "firstScope", "restScopes", "(Ljava/lang/Object;Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "concat", "collection", "core"})
public final class ScopeUtilsKt {
    @Nullable
    public static final <T> Collection<T> concat(@Nullable Collection<? extends T> $receiver, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkParameterIsNotNull(collection, (String)"collection");
        if (collection.isEmpty()) {
            return $receiver;
        }
        if ($receiver == null) {
            return collection;
        }
        if ($receiver instanceof LinkedHashSet) {
            ((LinkedHashSet)$receiver).addAll(collection);
            return $receiver;
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>($receiver);
        result.addAll(collection);
        return result;
    }

    @NotNull
    public static final <T> Collection<T> concatInOrder(@Nullable Collection<? extends T> c1, @Nullable Collection<? extends T> c2) {
        Collection result;
        Collection collection;
        Collection collection2;
        if (c1 == null || c1.isEmpty()) {
            collection2 = c2;
        } else if (c2 == null || c2.isEmpty()) {
            collection2 = c1;
        } else {
            LinkedHashSet<T> result2 = new LinkedHashSet<T>();
            result2.addAll(c1);
            result2.addAll(c2);
            collection2 = result2;
        }
        if ((collection = (result = collection2)) == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(@NotNull List<? extends Scope> scopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (scopes.isEmpty()) {
            return SetsKt.emptySet();
        }
        Collection<T> result = null;
        for (Scope scope : scopes) {
            result = ScopeUtilsKt.concat(result, (Collection)callback.invoke(scope));
        }
        Collection<T> collection = result;
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(Scope firstScope, @NotNull List<? extends Scope> restScopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Intrinsics.checkParameterIsNotNull(restScopes, (String)"restScopes");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Collection<T> result = (Collection<T>)callback.invoke(firstScope);
        for (Scope scope : restScopes) {
            result = ScopeUtilsKt.concat(result, (Collection)callback.invoke(scope));
        }
        Collection<T> collection = result;
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @Nullable
    public static final <Scope, T extends ClassifierDescriptor> T getFirstClassifierDiscriminateHeaders(@NotNull List<? extends Scope> scopes, @NotNull Function1<? super Scope, ? extends T> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        ClassifierDescriptor result = null;
        for (Scope scope : scopes) {
            ClassifierDescriptor newResult2 = (ClassifierDescriptor)callback.invoke(scope);
            if (newResult2 == null) continue;
            if (newResult2 instanceof ClassifierDescriptorWithTypeParameters && ((ClassifierDescriptorWithTypeParameters)newResult2).isExpect()) {
                if (result != null) continue;
                result = newResult2;
                continue;
            }
            return (T)newResult2;
        }
        return (T)result;
    }
}

