/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtilsKt;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/jps/build/JpsJsModuleUtils;", "", "()V", "getDependencyModulesAndSources", "", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "result", "", "", "getLibraryFiles", "getLibraryFilesAndDependencies", "", "getOutputFile", "Ljava/io/File;", "outputDir", "moduleName", "isTests", "", "getOutputMetaFile", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "suffix", "jps-plugin"})
public final class JpsJsModuleUtils {
    public static final JpsJsModuleUtils INSTANCE;

    @NotNull
    public final List<String> getLibraryFilesAndDependencies(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        ArrayList result = new ArrayList();
        this.getLibraryFiles(target, result);
        this.getDependencyModulesAndSources(target, result);
        return result;
    }

    public final void getLibraryFiles(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsUtils.getAllDependencies(target);
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesEnumerator, (String)"JpsUtils.getAllDependencies(target)");
        Set libraries = jpsJavaDependenciesEnumerator.getLibraries();
        for (JpsLibrary library : libraries) {
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryRoot, (String)"root");
                String string = JpsPathUtil.urlToPath((String)jpsLibraryRoot.getUrl());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JpsPathUtil.urlToPath(root.url)");
                result.add(string);
            }
        }
    }

    public final void getDependencyModulesAndSources(@NotNull ModuleBuildTarget target, @NotNull List<String> result) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        JpsUtils.getAllDependencies(target).processModules((Consumer)new Consumer<JpsModule>(target, result){
            final /* synthetic */ ModuleBuildTarget $target;
            final /* synthetic */ List $result;

            public void consume(@NotNull JpsModule module) {
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                if (Intrinsics.areEqual((Object)module.getModuleType(), (Object)JpsJavaModuleType.INSTANCE) ^ true) {
                    return;
                }
                if ((Intrinsics.areEqual((Object)module, (Object)this.$target.getModule()) ^ true || this.$target.isTests()) && JpsJsModuleUtilsKt.getHasProductionSourceRoot(module)) {
                    this.addTarget(module, false);
                }
                if (Intrinsics.areEqual((Object)module, (Object)this.$target.getModule()) ^ true && this.$target.isTests() && JpsJsModuleUtilsKt.getHasTestSourceRoot(module)) {
                    this.addTarget(module, true);
                }
            }

            public final void addTarget(@NotNull JpsModule module, boolean isTests) {
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                File metaInfoFile = JpsJsModuleUtils.getOutputMetaFile(module, isTests);
                if (metaInfoFile.exists()) {
                    String string = metaInfoFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"metaInfoFile.absolutePath");
                    this.$result.add(string);
                }
            }
            {
                this.$target = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final File getOutputMetaFile(@NotNull JpsModule module, boolean isTests) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleBuildTarget moduleBuildTarget = new ModuleBuildTarget(module, isTests ? JavaModuleBuildTargetType.TEST : JavaModuleBuildTargetType.PRODUCTION);
        File outputDir2 = KotlinBuilderModuleScriptGenerator.INSTANCE.getOutputDirSafe(moduleBuildTarget);
        String string = module.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
        return JpsJsModuleUtils.getOutputMetaFile(outputDir2, string, isTests);
    }

    @JvmStatic
    @NotNull
    public static final File getOutputFile(@NotNull File outputDir2, @NotNull String moduleName, boolean isTests) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir2, moduleName + INSTANCE.suffix(isTests) + ".js");
    }

    @JvmStatic
    @NotNull
    public static final File getOutputMetaFile(@NotNull File outputDir2, @NotNull String moduleName, boolean isTests) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new File(outputDir2, moduleName + INSTANCE.suffix(isTests) + ".meta.js");
    }

    private final String suffix(boolean isTests) {
        return isTests ? "_test" : "";
    }

    private JpsJsModuleUtils() {
    }

    static {
        JpsJsModuleUtils jpsJsModuleUtils;
        INSTANCE = jpsJsModuleUtils = new JpsJsModuleUtils();
    }
}

