/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.ant.dom.AntDomFileDescription;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AntRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement[] elements = AntRenameHandler.getElements(dataContext);
        return elements != null && elements.length > 1;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement[] elements;
        if (project == null) {
            AntRenameHandler.$$$reportNull$$$0(0);
        }
        if ((elements = AntRenameHandler.getElements(dataContext)) != null && elements.length > 0) {
            this.invoke(project, new PsiElement[]{elements[0]}, dataContext);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            AntRenameHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            AntRenameHandler.$$$reportNull$$$0(2);
        }
        super.invoke(project, elements, dataContext);
    }

    @Nullable
    private static PsiElement[] getElements(DataContext dataContext) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (!(psiFile instanceof XmlFile) || !AntDomFileDescription.isAntFile((XmlFile)psiFile)) {
            return null;
        }
        Editor editor = (Editor)LangDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        return AntRenameHandler.getPsiElementsIn(editor, psiFile);
    }

    @Nullable
    private static PsiElement[] getPsiElementsIn(Editor editor, PsiFile psiFile) {
        try {
            PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset());
            if (reference == null) {
                return null;
            }
            Collection candidates = TargetElementUtil.getInstance().getTargetCandidates(reference);
            return (PsiElement[])ContainerUtil.toArray((Collection)candidates, (Object[])new PsiElement[candidates.size()]);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ant/refactoring/AntRenameHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

