/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PropertyExpander {
    private static final Pattern $$_PATTERN = Pattern.compile("\\$\\$");
    final List<PropertiesProvider> myProviders;
    final Resolver myResolver;
    final Set<String> myNamesToSkip;
    private PropertyExpansionListener myPropertyExpansionListener;

    public PropertyExpander(@NotNull String str) {
        if (str == null) {
            PropertyExpander.$$$reportNull$$$0(0);
        }
        this(str, Collections.emptySet());
    }

    private PropertyExpander(@NotNull String str, Set<String> namesToSkip) {
        if (str == null) {
            PropertyExpander.$$$reportNull$$$0(1);
        }
        this.myProviders = new ArrayList<PropertiesProvider>();
        this.myNamesToSkip = new HashSet<String>();
        this.myResolver = new Resolver(str, namesToSkip);
        this.myNamesToSkip.addAll(namesToSkip);
    }

    public PropertyExpansionListener setPropertyExpansionListener(PropertyExpansionListener listener) {
        PropertyExpansionListener prevListener = this.myPropertyExpansionListener;
        this.myPropertyExpansionListener = listener;
        return prevListener;
    }

    public boolean hasPropertiesToExpand() {
        return this.myResolver.hasNext();
    }

    public void acceptProvider(PropertiesProvider provider) {
        while (this.myResolver.hasNext()) {
            String propValue;
            String propName = this.myResolver.next();
            String value = provider.getPropertyValue(propName);
            if (value == null) continue;
            this.myNamesToSkip.add(propName);
            if (provider instanceof PropertiesProvider.SkipPropertyExpansionInValues) {
                propValue = value;
            } else {
                PropertyExpander propertyValueExpander = new PropertyExpander(value, this.myNamesToSkip);
                propertyValueExpander.setPropertyExpansionListener(this.myPropertyExpansionListener);
                if (propertyValueExpander.hasPropertiesToExpand()) {
                    for (PropertiesProvider p : this.myProviders) {
                        propertyValueExpander.acceptProvider(p);
                        if (propertyValueExpander.hasPropertiesToExpand()) continue;
                        break;
                    }
                    if (propertyValueExpander.hasPropertiesToExpand()) {
                        propertyValueExpander.acceptProvider(provider);
                    }
                }
                propValue = propertyValueExpander.getResult();
            }
            this.myResolver.replace(propValue);
            this.notifyPropertyExpanded(propName, propValue);
        }
        this.myProviders.add(provider);
        this.myResolver.restart();
    }

    public void notifyPropertyExpanded(String propName, String propValue) {
        PropertyExpansionListener listener = this.myPropertyExpansionListener;
        if (listener != null) {
            listener.onPropertyExpanded(propName, propValue);
        }
    }

    @NotNull
    public String getResult() {
        String string = this.myResolver.getResult();
        if (string == null) {
            PropertyExpander.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/dom/PropertyExpander";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/dom/PropertyExpander";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements Iterator<String> {
        private int myCurrentIndex = -1;
        private List<Pair<String, Integer>> myPropertyNames;
        private StringBuilder myBuilder;

        private Resolver(String str, Set<String> namesToSkip) {
            this.myBuilder = new StringBuilder(str);
            int startProp = 0;
            while ((startProp = str.indexOf("${", startProp)) >= 0) {
                if (startProp > 0 && str.charAt(startProp - 1) == '$') {
                    startProp += 2;
                    continue;
                }
                int endProp = str.indexOf(125, startProp + 2);
                if (endProp <= startProp + 2) {
                    startProp += 2;
                    continue;
                }
                String prop = str.substring(startProp + 2, endProp);
                if (!namesToSkip.contains(prop)) {
                    if (this.myPropertyNames == null) {
                        this.myPropertyNames = new ArrayList<Pair<String, Integer>>();
                    }
                    this.myPropertyNames.add((Pair<String, Integer>)new Pair((Object)prop, (Object)startProp));
                }
                startProp += 2;
            }
            if (this.myPropertyNames == null) {
                this.myPropertyNames = Collections.emptyList();
            }
        }

        void restart() {
            this.myCurrentIndex = -1;
        }

        void replace(String newValue) {
            String name = this.getPropertyName(this.myCurrentIndex);
            int shift = newValue.length() - name.length() - 3;
            for (int idx = this.myCurrentIndex + 1; idx < this.myPropertyNames.size(); ++idx) {
                int currentOffset = this.getPropertyOffset(idx);
                this.setPropertyOffset(idx, currentOffset + shift);
            }
            int offset = this.getPropertyOffset(this.myCurrentIndex);
            this.myBuilder.replace(offset, offset + name.length() + 3, newValue);
            this.myPropertyNames.remove(this.myCurrentIndex);
            --this.myCurrentIndex;
        }

        private String getPropertyName(int index) {
            return (String)this.myPropertyNames.get(index).getFirst();
        }

        private int getPropertyOffset(int index) {
            return (Integer)this.myPropertyNames.get(index).getSecond();
        }

        private void setPropertyOffset(int index, int value) {
            Pair<String, Integer> pair = this.myPropertyNames.get(index);
            this.myPropertyNames.set(index, (Pair<String, Integer>)new Pair(pair.getFirst(), (Object)value));
        }

        String getResult() {
            String value = this.myBuilder.toString();
            if (value.indexOf("$$") >= 0) {
                return $$_PATTERN.matcher(value).replaceAll("\\$");
            }
            return value;
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentIndex + 1 < this.myPropertyNames.size();
        }

        @Override
        public String next() {
            return this.getPropertyName(++this.myCurrentIndex);
        }

        @Override
        public void remove() {
            this.replace("");
        }
    }

    public static interface PropertyExpansionListener {
        public void onPropertyExpanded(String var1, String var2);
    }
}

