/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.dom.AntDomAnt;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomReferenceBase;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.dom.TargetResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AntDomTargetReference
extends AntDomReferenceBase
implements BindablePsiReference {
    private final ReferenceGroup myGroup;

    public AntDomTargetReference(PsiElement element) {
        super(element, true);
        this.myGroup = null;
    }

    public AntDomTargetReference(PsiElement element, TextRange range, ReferenceGroup group) {
        super(element, range, true);
        this.myGroup = group;
        group.addReference(this);
    }

    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)MyResolver.INSTANCE, false, false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        TargetResolver.Result result;
        AntDomTarget pointingToTarget;
        DomElement targetDomElement;
        if (element == null) {
            AntDomTargetReference.$$$reportNull$$$0(0);
        }
        if ((targetDomElement = AntDomTargetReference.toDomElement(element)) != null && (pointingToTarget = (AntDomTarget)targetDomElement.getParentOfType(AntDomTarget.class, false)) != null && (result = this.doResolve(null)) != null) {
            Map<String, AntDomTarget> variants = result.getVariants();
            String newName = null;
            if (!variants.isEmpty()) {
                ArrayList<Couple> prefixNamePairs = null;
                for (Map.Entry<String, AntDomTarget> entry : variants.entrySet()) {
                    String candidateTargetName;
                    String candidateName;
                    AntDomTarget candidateTarget = entry.getValue();
                    if (!pointingToTarget.equals(candidateTarget) || !(candidateName = entry.getKey()).endsWith(candidateTargetName = candidateTarget.getName().getRawText())) continue;
                    String prefix = candidateName.substring(0, candidateName.length() - candidateTargetName.length());
                    if (prefixNamePairs == null) {
                        prefixNamePairs = new ArrayList<Couple>();
                    }
                    prefixNamePairs.add(Couple.of((Object)prefix, (Object)candidateName));
                }
                String currentRefText = this.getCanonicalText();
                for (Couple pair : prefixNamePairs) {
                    String prefix = (String)pair.getFirst();
                    String effectiveName = (String)pair.getSecond();
                    if (!currentRefText.startsWith(prefix) || newName != null && effectiveName.length() <= newName.length()) continue;
                    newName = effectiveName;
                }
            }
            if (newName != null) {
                this.handleElementRename(newName);
                if (this.myGroup != null) {
                    this.myGroup.textChanged(this, newName);
                }
            }
        }
        return this.getElement();
    }

    @Nullable
    private AntDomElement getHostingAntDomElement() {
        DomElement selfElement = DomUtil.getDomElement((PsiElement)this.getElement());
        if (selfElement == null) {
            return null;
        }
        return (AntDomElement)selfElement.getParentOfType(AntDomElement.class, false);
    }

    @NotNull
    public Object[] getVariants() {
        TargetResolver.Result result = this.doResolve(this.getCanonicalText());
        if (result == null) {
            if (EMPTY_ARRAY == null) {
                AntDomTargetReference.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        Map<String, AntDomTarget> variants = result.getVariants();
        ArrayList<LookupElement> resVariants = new ArrayList<LookupElement>();
        Set<String> existing = this.getExistingNames();
        for (String s : variants.keySet()) {
            if (existing.contains(s)) continue;
            LookupElementBuilder builder = LookupElementBuilder.create((String)s).withCaseSensitivity(false);
            LookupElement element = AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder);
            resVariants.add(element);
        }
        Object[] objectArray = ContainerUtil.toArray(resVariants, (Object[])new Object[resVariants.size()]);
        if (objectArray == null) {
            AntDomTargetReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Nullable
    private TargetResolver.Result doResolve(@Nullable String referenceText) {
        AntDomTarget contextTarget;
        AntDomProject projectToSearchFrom;
        AntDomElement hostingElement = this.getHostingAntDomElement();
        if (hostingElement == null) {
            return null;
        }
        if (hostingElement instanceof AntDomAnt) {
            PsiFileSystemItem antFile = (PsiFileSystemItem)((AntDomAnt)hostingElement).getAntFilePath().getValue();
            projectToSearchFrom = antFile instanceof PsiFile ? AntSupport.getAntDomProjectForceAntFile((PsiFile)antFile) : null;
            contextTarget = null;
        } else {
            projectToSearchFrom = hostingElement.getContextAntProject();
            contextTarget = (AntDomTarget)hostingElement.getParentOfType(AntDomTarget.class, false);
        }
        if (projectToSearchFrom == null) {
            return null;
        }
        return TargetResolver.resolve(projectToSearchFrom, contextTarget, referenceText == null ? Collections.emptyList() : Collections.singletonList(referenceText));
    }

    private Set<String> getExistingNames() {
        String dependsString;
        AntDomElement hostingElement = this.getHostingAntDomElement();
        if (hostingElement == null) {
            return Collections.emptySet();
        }
        AntDomTarget contextTarget = (AntDomTarget)hostingElement.getParentOfType(AntDomTarget.class, false);
        if (contextTarget == null) {
            return Collections.emptySet();
        }
        ArrayListSet existing = new ArrayListSet();
        String selfName = contextTarget.getName().getStringValue();
        if (selfName != null) {
            existing.add(selfName);
        }
        if ((dependsString = contextTarget.getDependsList().getRawText()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(dependsString, ",", false);
            while (tokenizer.hasMoreTokens()) {
                existing.add(tokenizer.nextToken().trim());
            }
        }
        return existing;
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("cannot.resolve.target", this.getCanonicalText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/dom/AntDomTargetReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/dom/AntDomTargetReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReferenceGroup {
        private List<AntDomTargetReference> myRefs = new ArrayList<AntDomTargetReference>();

        public void addReference(AntDomTargetReference ref) {
            this.myRefs.add(ref);
        }

        public void textChanged(AntDomTargetReference ref, String newText) {
            Integer lengthDelta = null;
            for (AntDomTargetReference r : this.myRefs) {
                if (lengthDelta != null) {
                    r.setRangeInElement(r.getRangeInElement().shiftRight(lengthDelta.intValue()));
                    continue;
                }
                if (!r.equals(ref)) continue;
                TextRange range = r.getRangeInElement();
                int oldLength = range.getLength();
                lengthDelta = new Integer(newText.length() - oldLength);
                r.setRangeInElement(range.grown(lengthDelta.intValue()));
            }
        }
    }

    private static class MyResolver
    implements ResolveCache.Resolver {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        public PsiElement resolve(@NotNull PsiReference psiReference, boolean incompleteCode) {
            TargetResolver.Result result;
            if (psiReference == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if ((result = ((AntDomTargetReference)psiReference).doResolve(psiReference.getCanonicalText())) == null) {
                return null;
            }
            Pair<AntDomTarget, String> pair = result.getResolvedTarget(psiReference.getCanonicalText());
            DomTarget domTarget = pair != null && pair.getFirst() != null ? DomTarget.getTarget((DomElement)((DomElement)pair.getFirst())) : null;
            return domTarget != null ? PomService.convertToPsi(domTarget) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReference", "com/intellij/lang/ant/dom/AntDomTargetReference$MyResolver", "resolve"));
        }
    }
}

