/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.AntRunProfileState;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.TargetChooserDialog;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntRunConfiguration
extends LocatableConfigurationBase
implements RunProfileWithCompileBeforeLaunchOption {
    private AntSettings mySettings = new AntSettings();

    public AntRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public RunConfiguration clone() {
        AntRunConfiguration configuration = (AntRunConfiguration)super.clone();
        configuration.mySettings = this.mySettings.copy();
        return configuration;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        AntConfigurationSettingsEditor antConfigurationSettingsEditor = new AntConfigurationSettingsEditor();
        if (antConfigurationSettingsEditor == null) {
            AntRunConfiguration.$$$reportNull$$$0(0);
        }
        return antConfigurationSettingsEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!AntConfiguration.getInstance(this.getProject()).isInitialized()) {
            throw new RuntimeConfigurationException("Ant Configuration still haven't been initialized");
        }
        if (this.getTarget() == null) {
            throw new RuntimeConfigurationException("Target is not specified", "Missing parameters");
        }
    }

    public String suggestedName() {
        AntBuildTarget target = this.getTarget();
        return target != null ? target.getDisplayName() : "";
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            AntRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            AntRunConfiguration.$$$reportNull$$$0(2);
        }
        return new AntRunProfileState(env);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySettings.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.mySettings.writeExternal(element);
    }

    @Nullable
    public AntBuildTarget getTarget() {
        return GlobalAntConfiguration.getInstance().findTarget(this.getProject(), this.mySettings.myFileUrl, this.mySettings.myTargetName);
    }

    @NotNull
    public List<BuildFileProperty> getProperties() {
        List<BuildFileProperty> list = Collections.unmodifiableList(this.mySettings.myProperties);
        if (list == null) {
            AntRunConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean acceptSettings(AntBuildTarget target) {
        VirtualFile virtualFile = target.getModel().getBuildFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        this.mySettings.myFileUrl = virtualFile.getUrl();
        this.mySettings.myTargetName = target.getName();
        return true;
    }

    private static void copyProperties(Iterable<BuildFileProperty> from, List<BuildFileProperty> to) {
        to.clear();
        for (BuildFileProperty p : from) {
            to.add(p.clone());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/execution/AntRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/execution/AntRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PropertiesTable
    extends ListTableWithButtons<BuildFileProperty> {
        private PropertiesTable() {
        }

        protected ListTableModel createListModel() {
            TableColumn nameColumn = new TableColumn("Name"){

                @Nullable
                public String valueOf(BuildFileProperty property) {
                    return property.getPropertyName();
                }

                public void setValue(BuildFileProperty property, String value) {
                    property.setPropertyName(value);
                }
            };
            TableColumn valueColumn = new TableColumn("Value"){

                @Nullable
                public String valueOf(BuildFileProperty property) {
                    return property.getPropertyValue();
                }

                public void setValue(BuildFileProperty property, String value) {
                    property.setPropertyValue(value);
                }
            };
            return new ListTableModel(new ColumnInfo[]{nameColumn, valueColumn});
        }

        protected BuildFileProperty createElement() {
            return new BuildFileProperty();
        }

        protected boolean isEmpty(BuildFileProperty element) {
            return StringUtil.isEmpty((String)element.getPropertyName()) && StringUtil.isEmpty((String)element.getPropertyValue());
        }

        protected BuildFileProperty cloneElement(BuildFileProperty p) {
            return p.clone();
        }

        protected boolean canDeleteElement(BuildFileProperty selection) {
            return true;
        }

        public List<BuildFileProperty> getElements() {
            return super.getElements();
        }

        private static abstract class TableColumn
        extends ListTableWithButtons.ElementsColumnInfoBase<BuildFileProperty> {
            public TableColumn(String name) {
                super(name);
            }

            public boolean isCellEditable(BuildFileProperty property) {
                return true;
            }

            @Nullable
            protected String getDescription(BuildFileProperty element) {
                return null;
            }
        }
    }

    private class AntConfigurationSettingsEditor
    extends SettingsEditor<RunConfiguration> {
        private String myFileUrl = null;
        private String myTargetName = null;
        private final JTextField myTextField = new JTextField();
        private final PropertiesTable myPropTable = new PropertiesTable();
        private ActionListener myActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntBuildTarget buildTarget = AntRunConfiguration.this.getTarget();
                TargetChooserDialog dlg = new TargetChooserDialog(AntRunConfiguration.this.getProject(), buildTarget);
                if (dlg.showAndGet()) {
                    VirtualFile vFile;
                    AntConfigurationSettingsEditor.this.myFileUrl = null;
                    AntConfigurationSettingsEditor.this.myTargetName = null;
                    buildTarget = dlg.getSelectedTarget();
                    if (buildTarget != null && (vFile = buildTarget.getModel().getBuildFile().getVirtualFile()) != null) {
                        AntConfigurationSettingsEditor.this.myFileUrl = vFile.getUrl();
                        AntConfigurationSettingsEditor.this.myTargetName = buildTarget.getName();
                    }
                    AntConfigurationSettingsEditor.this.updateUI();
                }
            }
        };

        private AntConfigurationSettingsEditor() {
        }

        private void updateUI() {
            this.myTextField.setText("");
            if (this.myFileUrl != null && this.myTargetName != null) {
                this.myTextField.setText(this.myTargetName);
            }
            this.myPropTable.refreshValues();
            this.fireEditorStateChanged();
        }

        protected void resetEditorFrom(@NotNull RunConfiguration s) {
            if (s == null) {
                AntConfigurationSettingsEditor.$$$reportNull$$$0(0);
            }
            AntRunConfiguration config = (AntRunConfiguration)s;
            this.myFileUrl = config.mySettings.myFileUrl;
            this.myTargetName = config.mySettings.myTargetName;
            this.myPropTable.setValues(config.mySettings.myProperties);
            this.updateUI();
        }

        protected void applyEditorTo(@NotNull RunConfiguration s) throws ConfigurationException {
            if (s == null) {
                AntConfigurationSettingsEditor.$$$reportNull$$$0(1);
            }
            AntRunConfiguration config = (AntRunConfiguration)s;
            config.mySettings.myFileUrl = this.myFileUrl;
            config.mySettings.myTargetName = this.myTargetName;
            AntRunConfiguration.copyProperties(ContainerUtil.filter(this.myPropTable.getElements(), property -> !this.myPropTable.isEmpty((BuildFileProperty)property)), config.mySettings.myProperties);
        }

        @NotNull
        protected JComponent createEditor() {
            this.myTextField.setEditable(false);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)LabeledComponent.create((JComponent)new TextFieldWithBrowseButton(this.myTextField, this.myActionListener), (String)"Target name", (String)"West"), "North");
            LabeledComponent tableComponent = LabeledComponent.create((JComponent)this.myPropTable.getComponent(), (String)"Ant Properties");
            tableComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            panel.add((Component)tableComponent, "Center");
            JPanel jPanel = panel;
            if (jPanel == null) {
                AntConfigurationSettingsEditor.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ant/config/execution/AntRunConfiguration$AntConfigurationSettingsEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ant/config/execution/AntRunConfiguration$AntConfigurationSettingsEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resetEditorFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyEditorTo";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AntSettings
    implements JDOMExternalizable {
        private static final String SETTINGS = "antsettings";
        private static final String PROPERTY = "property";
        private static final String FILE = "antfile";
        private static final String TARGET = "target";
        private String myFileUrl = null;
        private String myTargetName = null;
        private final List<BuildFileProperty> myProperties = new ArrayList<BuildFileProperty>();

        public AntSettings() {
        }

        public AntSettings(String fileUrl, String targetName) {
            this.myFileUrl = fileUrl;
            this.myTargetName = targetName;
        }

        public String toString() {
            return this.myTargetName + "@" + this.myFileUrl;
        }

        public AntSettings copy() {
            AntSettings copy = new AntSettings(this.myFileUrl, this.myTargetName);
            AntRunConfiguration.copyProperties(this.myProperties, copy.myProperties);
            return copy;
        }

        public void readExternal(Element element) throws InvalidDataException {
            if ((element = element.getChild(SETTINGS)) != null) {
                this.myFileUrl = element.getAttributeValue(FILE);
                this.myTargetName = element.getAttributeValue(TARGET);
                this.myProperties.clear();
                for (Element pe : element.getChildren(PROPERTY)) {
                    BuildFileProperty prop = new BuildFileProperty();
                    prop.readExternal(pe);
                    this.myProperties.add(prop);
                }
            }
        }

        public void writeExternal(Element element) throws WriteExternalException {
            if (this.myFileUrl != null && this.myTargetName != null) {
                Element settingsElem = new Element(SETTINGS);
                settingsElem.setAttribute(FILE, this.myFileUrl);
                settingsElem.setAttribute(TARGET, this.myTargetName);
                for (BuildFileProperty property : this.myProperties) {
                    Element pe = new Element(PROPERTY);
                    property.writeExternal(pe);
                    settingsElem.addContent(pe);
                }
                element.addContent(settingsElem);
            }
        }
    }
}

