/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.android.parcel.Parceler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableDeclarationCheckerKt;
import org.jetbrains.kotlin.android.parcel.quickfixes.AbstractParcelableQuickFix;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findCreatorClass$;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findFunction$;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$invoke$;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\f\r\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix;", "Lorg/jetbrains/kotlin/psi/KtClass;", "function", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getText", "", "invoke", "", "ktPsiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "parcelableClass", "Companion", "FactoryForCREATOR", "FactoryForWrite", "android-extensions-ide"})
public final class ParcelMigrateToParcelizeQuickFix
extends AbstractParcelableQuickFix<KtClass> {
    private static final FqName PARCELER_FQNAME;
    private static final Name PARCELER_WRITE_FUNCTION_NAME;
    private static final Name PARCELER_CREATE_FUNCTION_NAME;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return "Migrate to ''Parceler'' companion object";
    }

    @Override
    public void invoke(@NotNull KtPsiFactory ktPsiFactory, @NotNull KtClass parcelableClass) {
        Object createFunction;
        Object anchor$iv;
        KtClassBody body$iv3;
        KtDeclaration declaration$iv;
        PsiElement anchor$iv2;
        KtClassBody body$iv2;
        Pair this_$iv;
        String parcelParameterName;
        Object $receiver;
        KtFunction newFunction;
        KtNamedFunction ktNamedFunction;
        boolean bl;
        Object it;
        String parcelerTypeArg;
        BindingContext bindingContext;
        Pair parcelerObject;
        block55: {
            ClassDescriptor parcelerObjectDescriptor;
            Intrinsics.checkParameterIsNotNull((Object)ktPsiFactory, (String)"ktPsiFactory");
            Intrinsics.checkParameterIsNotNull((Object)parcelableClass, (String)"parcelableClass");
            Pair pair = ParcelMigrateToParcelizeQuickFix.Companion.findParcelerCompanionObject(parcelableClass);
            if (pair == null || (pair = (KtObjectDeclaration)pair.getFirst()) == null) {
                pair = PsiModificationUtilsKt.getOrCreateCompanionObject((KtClass)parcelableClass);
            }
            parcelerObject = pair;
            bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)parcelerObject), (BodyResolveMode)BodyResolveMode.PARTIAL);
            String string = parcelableClass.getName();
            if (string == null) {
                ParcelMigrateToParcelizeQuickFix parcelMigrateToParcelizeQuickFix;
                ParcelMigrateToParcelizeQuickFix $receiver2 = parcelMigrateToParcelizeQuickFix = this;
                ParcelMigrateToParcelizeQuickFix.Companion.getLOG().error("Parceler class should not be an anonymous class");
                return;
            }
            parcelerTypeArg = string;
            ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)parcelerObject);
            if (classDescriptor == null) {
                ParcelMigrateToParcelizeQuickFix $receiver2;
                ParcelMigrateToParcelizeQuickFix $receiver3 = $receiver2 = this;
                Logger logger = ParcelMigrateToParcelizeQuickFix.Companion.getLOG();
                StringBuilder stringBuilder = new StringBuilder().append("Unable to resolve parceler object for ");
                String string2 = parcelableClass.getName();
                if (string2 == null) {
                    string2 = "<unnamed Parcelable class>";
                }
                logger.error(stringBuilder.append(string2).toString());
                return;
            }
            ClassDescriptor classDescriptor2 = parcelerObjectDescriptor = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"parcelerObjectDescriptor");
            Sequence $receiver$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)classDescriptor2));
            for (Object element$iv : $receiver$iv) {
                it = (ClassifierDescriptor)element$iv;
                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)), (Object)ParcelMigrateToParcelizeQuickFix.Companion.getPARCELER_FQNAME())) continue;
                bl = true;
                break block55;
            }
            bl = false;
        }
        if (!bl) {
            String entryText = ParcelMigrateToParcelizeQuickFix.Companion.getPARCELER_FQNAME().asString() + "<" + parcelerTypeArg + ">";
            AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)parcelerObject.addSuperTypeListEntry((KtSuperTypeListEntry)ktPsiFactory.createSuperTypeEntry(entryText)));
        }
        KtNamedFunction oldWriteToParcelFunction = ParcelMigrateToParcelizeQuickFix.Companion.findWriteToParcelOverride(parcelableClass);
        KtClassOrObject ktClassOrObject = ParcelMigrateToParcelizeQuickFix.Companion.findCreatorClass(parcelableClass);
        if (ktClassOrObject != null) {
            Object element$iv;
            element$iv = ktClassOrObject;
            it = element$iv;
            ktNamedFunction = ParcelMigrateToParcelizeQuickFix.Companion.findCreateFromParcel((KtClassOrObject)it);
        } else {
            ktNamedFunction = null;
        }
        KtNamedFunction oldCreateFromParcelFunction = ktNamedFunction;
        for (KtSuperTypeListEntry superTypeEntry : parcelerObject.getSuperTypeListEntries()) {
            boolean bl2;
            block56: {
                KotlinType superClass;
                KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)superTypeEntry.getTypeReference());
                if (kotlinType == null || (kotlinType = kotlinType.getConstructor()) == null || (kotlinType = kotlinType.getDeclarationDescriptor()) == null) {
                    continue;
                }
                KotlinType kotlinType2 = superClass = kotlinType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"superClass");
                Sequence $receiver$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)kotlinType2);
                for (Object element$iv : $receiver$iv) {
                    ClassifierDescriptor it2 = (ClassifierDescriptor)element$iv;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it2)), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCELABLE_CREATOR_CLASS_FQNAME())) continue;
                    bl2 = true;
                    break block56;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            parcelerObject.removeSuperTypeListEntry(superTypeEntry);
        }
        if (Intrinsics.areEqual((Object)parcelerObject.getName(), (Object)"CREATOR")) {
            PsiElement psiElement = parcelerObject.getNameIdentifier();
            if (psiElement != null) {
                psiElement.delete();
            }
        }
        if (oldWriteToParcelFunction != null) {
            KtNamedFunction ktNamedFunction2 = ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction2 != null) {
                ktNamedFunction2.delete();
            }
            PsiElement psiElement = oldWriteToParcelFunction.copy();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            newFunction = (KtFunction)psiElement;
            oldWriteToParcelFunction.delete();
            newFunction.setName(ParcelMigrateToParcelizeQuickFix.Companion.getPARCELER_WRITE_FUNCTION_NAME().asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierKeywordToken, (String)"KtTokens.OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)newFunction;
            String string = parcelerTypeArg;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parcelerTypeArg");
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)ktCallableDeclaration, (KtTypeReference)ktPsiFactory.createType(string));
            KtParameterList ktParameterList = newFunction.getValueParameterList();
            if (ktParameterList != null) {
                boolean $receiver$iv;
                it = ktParameterList;
                $receiver = it;
                boolean bl3 = $receiver$iv = $receiver.getParameters().size() == 2;
                if (_Assertions.ENABLED && !$receiver$iv) {
                    String string3 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                Object e = $receiver.getParameters().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"parameters[0]");
                String string4 = ((KtParameter)e).getName();
                if (string4 == null) {
                    string4 = "parcel";
                }
                parcelParameterName = string4;
                Object e2 = $receiver.getParameters().get(1);
                Intrinsics.checkExpressionValueIsNotNull(e2, (String)"parameters[1]");
                String string5 = ((KtParameter)e2).getName();
                if (string5 == null) {
                    string5 = "flags";
                }
                String flagsParameterName = string5;
                int element$iv = $receiver.getParameters().size();
                int n = 0;
                int n2 = element$iv - 1;
                if (n <= n2) {
                    do {
                        int it3 = ++n;
                        $receiver.removeParameter(0);
                    } while (n != n2);
                }
                $receiver.addParameter(ktPsiFactory.createParameter("" + parcelParameterName + " : " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
                $receiver.addParameter(ktPsiFactory.createParameter("" + flagsParameterName + " : Int"));
            }
            this_$iv = parcelerObject;
            body$iv2 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement2 = body$iv2.getRBrace();
            if (psiElement2 == null && (psiElement2 = body$iv2.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            anchor$iv2 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement3 = body$iv2.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv2);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList2 = ((KtFunction)psiElement3).getValueParameterList();
            if (ktParameterList2 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList2);
            }
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject) == null) {
            String writeFunction = "fun " + parcelerTypeArg + ".write(parcel: " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + ", flags: Int) = TODO()";
            this_$iv = parcelerObject;
            declaration$iv = (KtDeclaration)ktPsiFactory.createFunction(writeFunction);
            body$iv3 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement = body$iv3.getRBrace();
            if (psiElement == null && (psiElement = body$iv3.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement4 = body$iv3.addAfter((PsiElement)declaration$iv, anchor$iv);
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList = ((KtNamedFunction)psiElement4).getValueParameterList();
            if (ktParameterList != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList);
            }
        }
        if (oldCreateFromParcelFunction != null) {
            KtNamedFunction ktNamedFunction3 = ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction3 != null) {
                ktNamedFunction3.delete();
            }
            PsiElement psiElement = oldCreateFromParcelFunction.copy();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            newFunction = (KtFunction)psiElement;
            if (Intrinsics.areEqual((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)oldCreateFromParcelFunction)), (Object)parcelerObject)) {
                oldCreateFromParcelFunction.delete();
            }
            newFunction.setName(ParcelMigrateToParcelizeQuickFix.Companion.getPARCELER_CREATE_FUNCTION_NAME().asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierKeywordToken, (String)"KtTokens.OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)newFunction), null);
            KtParameterList ktParameterList = newFunction.getValueParameterList();
            if (ktParameterList != null) {
                boolean body$iv3;
                this_$iv = ktParameterList;
                $receiver = this_$iv;
                boolean bl4 = body$iv3 = $receiver.getParameters().size() == 1;
                if (_Assertions.ENABLED && !body$iv3) {
                    anchor$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError(anchor$iv));
                }
                Object e = $receiver.getParameters().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"parameters[0]");
                String string = ((KtParameter)e).getName();
                if (string == null) {
                    string = "parcel";
                }
                parcelParameterName = string;
                $receiver.removeParameter(0);
                $receiver.addParameter(ktPsiFactory.createParameter("" + parcelParameterName + " : " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
            }
            this_$iv = parcelerObject;
            body$iv2 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement5 = body$iv2.getRBrace();
            if (psiElement5 == null && (psiElement5 = body$iv2.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            anchor$iv2 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement5, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement6 = body$iv2.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv2);
            if (psiElement6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList3 = ((KtFunction)psiElement6).getValueParameterList();
            if (ktParameterList3 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList3);
            }
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject) == null) {
            createFunction = "override fun create(parcel: " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + "): " + parcelerTypeArg + " = TODO()";
            this_$iv = parcelerObject;
            declaration$iv = (KtDeclaration)ktPsiFactory.createFunction((String)createFunction);
            body$iv3 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement = body$iv3.getRBrace();
            if (psiElement == null && (psiElement = body$iv3.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement7 = body$iv3.addAfter((PsiElement)declaration$iv, anchor$iv);
            if (psiElement7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList = ((KtNamedFunction)psiElement7).getValueParameterList();
            if (ktParameterList != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList);
            }
        }
        KtNamedFunction ktNamedFunction4 = ParcelMigrateToParcelizeQuickFix.Companion.findNewArrayOverride((KtObjectDeclaration)parcelerObject);
        if (ktNamedFunction4 != null) {
            ktNamedFunction4.delete();
        }
        KtNamedFunction ktNamedFunction5 = ParcelMigrateToParcelizeQuickFix.Companion.findDescribeContentsOverride(parcelableClass);
        if (ktNamedFunction5 != null) {
            KtExpression returnExpr;
            KtNamedFunction describeContentsFunction = createFunction = ktNamedFunction5;
            KtExpression ktExpression = describeContentsFunction.getBodyExpression();
            Object object = returnExpr = ktExpression != null ? IfThenUtilsKt.unwrapBlockOrParenthesis((KtExpression)ktExpression) : null;
            if (returnExpr instanceof KtReturnExpression && ((KtReturnExpression)returnExpr).getTargetLabel() == null) {
                Object returnValue;
                Object object2;
                CompileTimeConstant compileTimeConstant = (CompileTimeConstant)ResolutionUtils.analyze$default((KtElement)((KtElement)returnExpr), null, (int)1, null).get((ReadOnlySlice)BindingContext.COMPILE_TIME_VALUE, (Object)((KtReturnExpression)returnExpr).getReturnedExpression());
                if (compileTimeConstant != null) {
                    SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"TypeUtils.NO_EXPECTED_TYPE");
                    object2 = compileTimeConstant.getValue((KotlinType)simpleType);
                } else {
                    object2 = returnValue = null;
                }
                if (Intrinsics.areEqual((Object)returnValue, (Object)0)) {
                    Object object3 = (SimpleFunctionDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)describeContentsFunction);
                    if (object3 != null && (object3 = object3.getOverriddenDescriptors()) != null) {
                        if (object3.size() == 1) {
                            describeContentsFunction.delete();
                        }
                    }
                }
            }
        }
        Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)parcelerObject.getDeclarations());
        Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)invoke$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        for (KtProperty property : SequencesKt.filter((Sequence)sequence, (Function1)invoke.6.INSTANCE)) {
            if (ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)property), (FqName)AnnotationUtilKt.getJVM_FIELD_ANNOTATION_FQ_NAME()) == null) continue;
            property.delete();
        }
    }

    public ParcelMigrateToParcelizeQuickFix(@NotNull KtClass function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        super((KtElement)function);
    }

    static {
        Companion = new Companion(null);
        PARCELER_FQNAME = new FqName(Parceler.class.getName());
        PARCELER_WRITE_FUNCTION_NAME = Name.identifier((String)"write");
        PARCELER_CREATE_FUNCTION_NAME = Name.identifier((String)"create");
        LOG = Logger.getInstance(ParcelMigrateToParcelizeQuickFix.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForWrite;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix$AbstractFactory;", "()V", "android-extensions-ide"})
    public static final class FactoryForWrite
    extends AbstractParcelableQuickFix.AbstractFactory {
        public static final FactoryForWrite INSTANCE;

        private FactoryForWrite() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }

        static {
            FactoryForWrite factoryForWrite;
            INSTANCE = factoryForWrite = new FactoryForWrite();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForCREATOR;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix$AbstractFactory;", "()V", "android-extensions-ide"})
    public static final class FactoryForCREATOR
    extends AbstractParcelableQuickFix.AbstractFactory {
        public static final FactoryForCREATOR INSTANCE;

        private FactoryForCREATOR() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }

        static {
            FactoryForCREATOR factoryForCREATOR;
            INSTANCE = factoryForCREATOR = new FactoryForCREATOR();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0012H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0012H\u0002J\f\u0010\u0018\u001a\u00020\u0016*\u00020\u0012H\u0002J\f\u0010\u0019\u001a\u00020\u0016*\u00020\u0012H\u0002J\f\u0010\u001a\u001a\u00020\u0016*\u00020\u0012H\u0002J\f\u0010\u001b\u001a\u00020\u0016*\u00020\u0012H\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0012*\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0014*\u00020\u001fH\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u0012*\u00020\u001fH\u0002J'\u0010!\u001a\u0004\u0018\u00010\u0012*\u00020\u00142\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00160#\u00a2\u0006\u0002\b$H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010\u0012*\u00020\u001dH\u0002J\u001a\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020(\u0018\u00010'*\u00020\u001fH\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010\u0012*\u00020\u001dH\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010\u0012*\u00020\u001fH\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010,*\u00020-H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PARCELER_CREATE_FUNCTION_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getPARCELER_CREATE_FUNCTION_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "PARCELER_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "getPARCELER_FQNAME", "()Lorg/jetbrains/kotlin/name/FqName;", "PARCELER_WRITE_FUNCTION_NAME", "getPARCELER_WRITE_FUNCTION_NAME", "findCreateFromParcel", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "creator", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "doesLookLikeCreateFromParcelOverride", "", "doesLookLikeCreateImplementation", "doesLookLikeDescribeContentsOverride", "doesLookLikeNewArrayOverride", "doesLookLikeWriteImplementation", "doesLookLikeWriteToParcelOverride", "findCreateImplementation", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "findCreatorClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "findDescribeContentsOverride", "findFunction", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "findNewArrayOverride", "findParcelerCompanionObject", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findWriteImplementation", "findWriteToParcelOverride", "getFqName", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "android-extensions-ide"})
    public static final class Companion {
        private final FqName getPARCELER_FQNAME() {
            return PARCELER_FQNAME;
        }

        private final Name getPARCELER_WRITE_FUNCTION_NAME() {
            return PARCELER_WRITE_FUNCTION_NAME;
        }

        private final Name getPARCELER_CREATE_FUNCTION_NAME() {
            return PARCELER_CREATE_FUNCTION_NAME;
        }

        private final Logger getLOG() {
            return LOG;
        }

        private final Pair<KtObjectDeclaration, ClassDescriptor> findParcelerCompanionObject(@NotNull KtClass $receiver) {
            for (KtObjectDeclaration obj : $receiver.getCompanionObjects()) {
                ClassDescriptor objDescriptor;
                BindingContext bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)obj), (BodyResolveMode)BodyResolveMode.PARTIAL);
                if ((ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)obj) == null) {
                    continue;
                }
                ClassDescriptor classDescriptor = objDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"objDescriptor");
                for (ClassifierDescriptor superClassifier : DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)classDescriptor))) {
                    ClassDescriptor superClass;
                    ClassifierDescriptor classifierDescriptor = superClassifier;
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    if ((ClassDescriptor)classifierDescriptor == null) {
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)superClass)), (Object)this.getPARCELER_FQNAME())) continue;
                    return new Pair((Object)obj, (Object)objDescriptor);
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteToParcelOverride(@NotNull KtNamedFunction $receiver) {
            if (!Intrinsics.areEqual((Object)$receiver.getName(), (Object)"writeToParcel")) return false;
            if (!$receiver.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($receiver.getReceiverTypeReference() != null) return false;
            if ($receiver.getValueParameters().size() != 2) return false;
            if ($receiver.getTypeParameters().size() != 0) return false;
            Object e = $receiver.getValueParameters().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            Object e2 = $receiver.getValueParameters().get(1);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"valueParameters[1]");
            KtTypeReference ktTypeReference2 = ((KtParameter)e2).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)KotlinBuiltIns.FQ_NAMES._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeNewArrayOverride(@NotNull KtNamedFunction $receiver) {
            if (!Intrinsics.areEqual((Object)$receiver.getName(), (Object)"newArray")) return false;
            if (!$receiver.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($receiver.getReceiverTypeReference() != null) return false;
            if ($receiver.getValueParameters().size() != 1) return false;
            if ($receiver.getTypeParameters().size() != 0) return false;
            Object e = $receiver.getValueParameters().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)KotlinBuiltIns.FQ_NAMES._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeDescribeContentsOverride(@NotNull KtNamedFunction $receiver) {
            if (!Intrinsics.areEqual((Object)$receiver.getName(), (Object)"describeContents")) return false;
            if (!$receiver.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($receiver.getReceiverTypeReference() != null) return false;
            if ($receiver.getValueParameters().size() != 0) return false;
            if ($receiver.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = $receiver.getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)KotlinBuiltIns.FQ_NAMES._int.asString())) return false;
            return true;
        }

        private final KtNamedFunction findWriteToParcelOverride(@NotNull KtClass $receiver) {
            return this.findFunction((KtClassOrObject)$receiver, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteToParcelOverride.1.INSTANCE));
        }

        private final KtNamedFunction findDescribeContentsOverride(@NotNull KtClass $receiver) {
            return this.findFunction((KtClassOrObject)$receiver, (Function1<? super KtNamedFunction, Boolean>)((Function1)findDescribeContentsOverride.1.INSTANCE));
        }

        private final KtNamedFunction findNewArrayOverride(@NotNull KtObjectDeclaration $receiver) {
            return this.findFunction((KtClassOrObject)$receiver, (Function1<? super KtNamedFunction, Boolean>)((Function1)findNewArrayOverride.1.INSTANCE));
        }

        private final KtClassOrObject findCreatorClass(@NotNull KtClass $receiver) {
            for (KtObjectDeclaration companion : $receiver.getCompanionObjects()) {
                KtClassOrObject ktClassOrObject;
                KotlinSourceElement sourceElement;
                KtExpression initializer;
                KtProperty creatorProperty;
                Object v0;
                block11: {
                    Sequence $receiver$iv;
                    if (Intrinsics.areEqual((Object)companion.getName(), (Object)"CREATOR")) {
                        return (KtClassOrObject)companion;
                    }
                    Sequence sequence = CollectionsKt.asSequence((Iterable)companion.getDeclarations());
                    if (SequencesKt.filter((Sequence)$receiver$iv, (Function1)Companion$findCreatorClass$$inlined$filterIsInstance$1.INSTANCE) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    for (Object element$iv : $receiver$iv) {
                        KtProperty it = (KtProperty)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"CREATOR")) continue;
                        v0 = element$iv;
                        break block11;
                    }
                    v0 = null;
                }
                if ((KtProperty)v0 == null) {
                    continue;
                }
                if (ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)creatorProperty), (FqName)AnnotationUtilKt.getJVM_FIELD_ANNOTATION_FQ_NAME()) == null) {
                    continue;
                }
                if (creatorProperty.getInitializer() == null) {
                    continue;
                }
                Iterator iterator = initializer;
                if (iterator instanceof KtObjectLiteralExpression) {
                    KtExpression ktExpression = initializer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"initializer");
                    return (KtClassOrObject)((KtObjectLiteralExpression)ktExpression).getObjectDeclaration();
                }
                if (!(iterator instanceof KtCallExpression)) continue;
                KtElement ktElement = (KtElement)initializer;
                KtExpression ktExpression = initializer;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"initializer");
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)ktElement, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)ktExpression), (BodyResolveMode)BodyResolveMode.PARTIAL));
                Object object = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
                if (!(object instanceof ConstructorDescriptor)) {
                    object = null;
                }
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)object;
                Object constructedClass = constructorDescriptor != null ? constructorDescriptor.getConstructedClass() : null;
                if (constructedClass == null) continue;
                SourceElement sourceElement2 = constructedClass.getSource();
                if (!(sourceElement2 instanceof KotlinSourceElement)) {
                    sourceElement2 = null;
                }
                KotlinSourceElement kotlinSourceElement = sourceElement = (KotlinSourceElement)sourceElement2;
                Object object2 = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
                if (!(object2 instanceof KtClassOrObject)) {
                    object2 = null;
                }
                KtClassOrObject ktClassOrObject2 = (KtClassOrObject)object2;
                if (ktClassOrObject2 == null) continue;
                KtClassOrObject it = ktClassOrObject = ktClassOrObject2;
                return it;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateFromParcelOverride(@NotNull KtNamedFunction $receiver) {
            if (!Intrinsics.areEqual((Object)$receiver.getName(), (Object)"createFromParcel")) return false;
            if (!$receiver.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($receiver.getReceiverTypeReference() != null) return false;
            if ($receiver.getValueParameters().size() != 1) return false;
            if ($receiver.getTypeParameters().size() != 0) return false;
            Object e = $receiver.getValueParameters().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateFromParcel(KtClassOrObject creator) {
            return this.findFunction(creator, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateFromParcel.1.INSTANCE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteImplementation(@NotNull KtNamedFunction $receiver) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$receiver));
            String containingParcelableClassFqName = ktClassOrObject != null && (ktClassOrObject = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktClassOrObject))) != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null;
            if (!Intrinsics.areEqual((Object)$receiver.getName(), (Object)this.getPARCELER_WRITE_FUNCTION_NAME().asString())) return false;
            if (!$receiver.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            KtTypeReference ktTypeReference = $receiver.getReceiverTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)containingParcelableClassFqName)) return false;
            if ($receiver.getValueParameters().size() != 2) return false;
            if ($receiver.getTypeParameters().size() != 0) return false;
            Object e = $receiver.getValueParameters().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference2 = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            Object e2 = $receiver.getValueParameters().get(1);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"valueParameters[1]");
            KtTypeReference ktTypeReference3 = ((KtParameter)e2).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference3 != null ? this.getFqName(ktTypeReference3) : null), (Object)KotlinBuiltIns.FQ_NAMES._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateImplementation(@NotNull KtNamedFunction $receiver) {
            if (!Intrinsics.areEqual((Object)$receiver.getName(), (Object)this.getPARCELER_CREATE_FUNCTION_NAME().asString())) return false;
            if (!$receiver.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($receiver.getReceiverTypeReference() != null) return false;
            if ($receiver.getValueParameters().size() != 1) return false;
            if ($receiver.getTypeParameters().size() != 0) return false;
            Object e = $receiver.getValueParameters().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"valueParameters[0]");
            KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateImplementation(@NotNull KtObjectDeclaration $receiver) {
            return this.findFunction((KtClassOrObject)$receiver, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findWriteImplementation(@NotNull KtObjectDeclaration $receiver) {
            return this.findFunction((KtClassOrObject)$receiver, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findFunction(@NotNull KtClassOrObject $receiver, Function1<? super KtNamedFunction, Boolean> f) {
            Object v1;
            block2: {
                Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)$receiver.getDeclarations());
                Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)Companion$findFunction$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                $receiver$iv = sequence;
                for (Object element$iv : $receiver$iv) {
                    if (!((Boolean)f.invoke(element$iv)).booleanValue()) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            return v1;
        }

        private final String getFqName(@NotNull KtTypeReference $receiver) {
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)$receiver), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)$receiver);
            return kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = kotlinType.getDeclarationDescriptor()) != null && (kotlinType = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)kotlinType))) != null ? kotlinType.asString() : null;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteToParcelOverride(Companion $this, @NotNull KtNamedFunction $receiver) {
            return $this.doesLookLikeWriteToParcelOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeDescribeContentsOverride(Companion $this, @NotNull KtNamedFunction $receiver) {
            return $this.doesLookLikeDescribeContentsOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeNewArrayOverride(Companion $this, @NotNull KtNamedFunction $receiver) {
            return $this.doesLookLikeNewArrayOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateFromParcelOverride(Companion $this, @NotNull KtNamedFunction $receiver) {
            return $this.doesLookLikeCreateFromParcelOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateImplementation(Companion $this, @NotNull KtNamedFunction $receiver) {
            return $this.doesLookLikeCreateImplementation($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteImplementation(Companion $this, @NotNull KtNamedFunction $receiver) {
            return $this.doesLookLikeWriteImplementation($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

