/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.references.PlayFakeRenameableReferenceProvider;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.play.utils.beans.PlayRenameableImplicitVariable;
import com.intellij.play.utils.processors.ControllerMethodsProcessor;
import com.intellij.play.utils.processors.FieldTagImplicitVariablesProcessor;
import com.intellij.play.utils.processors.ImplicitVariablesProcessor;
import com.intellij.play.utils.processors.ListTagImplicitVariablesProcessor;
import com.intellij.play.utils.processors.LocalVariablesProcessor;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.play.utils.processors.RenderArgProcessor;
import com.intellij.play.utils.processors.TopLevelControllerPackagesProcessor;
import com.intellij.play.utils.processors.TopLevelControllersProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayUtils {
    public static final String CONTROLLERS_PKG = "controllers";
    public static PlayDeclarationsProcessor[] myDeclarationsProcessors = new PlayDeclarationsProcessor[]{new ImplicitVariablesProcessor(), new ControllerMethodsProcessor(), new TopLevelControllersProcessor(), new TopLevelControllerPackagesProcessor(), new LocalVariablesProcessor(), new RenderArgProcessor(), new ListTagImplicitVariablesProcessor(), new FieldTagImplicitVariablesProcessor()};

    public static boolean isController(@Nullable PsiClass psiClass) {
        return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"play.mvc.Controller");
    }

    public static boolean isPlayInstalled(Project project) {
        return !project.isDefault() && PackageIndex.getInstance((Project)project).getDirectoriesByPackageName("play.mvc", true).length > 0 && PackageIndex.getInstance((Project)project).getDirectoriesByPackageName("play.api.mvc", true).length == 0;
    }

    @Nullable
    public static PsiClass getObjectClass(Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project));
    }

    @Nullable
    public static PlayTag getContainingPlayTag(PsiElement expressionElement) {
        return (PlayTag)PsiTreeUtil.getParentOfType((PsiElement)expressionElement, PlayTag.class);
    }

    public static boolean processPlayDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        for (PlayDeclarationsProcessor declarationsProcessor : myDeclarationsProcessors) {
            if (declarationsProcessor.processElement(processor, state, scope)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSecondaryElements(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            return PlayPathUtils.getCorrespondingDirectory((PsiClass)psiElement) != null;
        }
        if (psiElement instanceof PsiMethod) {
            return PlayPathUtils.getCorrespondingView((PsiMethod)psiElement) != null;
        }
        if (psiElement instanceof PlayPsiFile) {
            return PlayPathUtils.getCorrespondingControllerMethods((PsiFile)psiElement).length > 0;
        }
        return false;
    }

    public static LocalSearchScope getPsiClassLocalScope(@NotNull PsiClass controller) {
        if (controller == null) {
            PlayUtils.$$$reportNull$$$0(0);
        }
        return new LocalSearchScope((PsiElement[])ArrayUtil.append((Object[])controller.getSupers(), (Object)controller));
    }

    public static Map<String, PlayImplicitVariable> getPutMethodInitVariables(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        if (psiMethod == null) {
            PlayUtils.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            PlayUtils.$$$reportNull$$$0(2);
        }
        ConcurrentMap set = ContainerUtil.newConcurrentMap();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiExpression expression;
            PsiExpression[] expressions;
            PsiMethodCallExpression methodCallExpression;
            if (set == null) {
                PlayUtils.$$$reportNull$$$0(3);
            }
            if ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class)) != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length == 2 && (expression = expressions[0]) instanceof PsiLiteralExpression) {
                String name = (String)((PsiLiteralExpression)expression).getValue();
                PsiType type = expressions[1].getType();
                if (name != null && type != null) {
                    set.put(name, new PlayRenameableImplicitVariable(name, type, PlayFakeRenameableReferenceProvider.getOrCreateRenamebaleFakeElement((PsiLiteral)((PsiLiteralExpression)expression))));
                }
            }
            return true;
        });
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        objectArray2[1] = "com/intellij/play/utils/PlayUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiClassLocalScope";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPutMethodInitVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getPutMethodInitVariables$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

