/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.play.console.BasicConsoleProcessRunner;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessLanguageConsoleViewWrapper
extends JPanel {
    private final LanguageConsoleView myConsoleView;

    public ProcessLanguageConsoleViewWrapper(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            ProcessLanguageConsoleViewWrapper.$$$reportNull$$$0(0);
        }
        this.myConsoleView = consoleView;
        this.setBorder((Border)new SideBorder(JBColor.border(), 1));
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PlayLangConsoleView", (ActionGroup)toolbarActions, false);
        this.setLayout(new BorderLayout());
        this.add((Component)actionToolbar.getComponent(), "West");
        this.add((Component)this.myConsoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)this);
        List<AnAction> actions = this.fillToolBarActions(toolbarActions);
        ProcessLanguageConsoleViewWrapper.registerActionShortcuts(actions, this.myConsoleView.getConsoleEditor().getComponent());
        ProcessLanguageConsoleViewWrapper.registerActionShortcuts(actions, this);
        this.updateUI();
    }

    public static void registerActionShortcuts(List<AnAction> actions, JComponent component) {
        for (AnAction action : actions) {
            if (action.getShortcutSet() == null) continue;
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
    }

    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions) {
        ArrayList<AnAction> actionList = new ArrayList<AnAction>();
        AnAction stopAction = this.createStopAction();
        actionList.add(stopAction);
        AnAction closeAction = this.createCloseAction(this.getProcessRunner());
        actionList.add(closeAction);
        actionList.add(LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)this.myConsoleView, text -> {
            try {
                this.getProcessRunner().runProcess((String)text);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }, (String)this.getProcessRunner().getHistoryId(), (String)this.getProcessRunner().getHistoryPersistenceId(), console -> this.getProcessRunner().isReady()));
        actionList.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        Collections.addAll(actionList, this.myConsoleView.createConsoleActions());
        toolbarActions.addAll(actionList);
        return actionList;
    }

    protected abstract BasicConsoleProcessRunner getProcessRunner();

    protected AnAction createCloseAction(final BasicConsoleProcessRunner processRunner) {
        return new CloseAction(null, null, this.myConsoleView.getProject()){

            public void actionPerformed(AnActionEvent e) {
                if (processRunner.getState() == BasicConsoleProcessRunner.State.EXECUTING) {
                    Process process = processRunner.getProcessHandler().getProcess();
                    OSProcessManager.getInstance().killProcessTree(process);
                }
                super.actionPerformed(e);
            }

            public Executor getExecutor() {
                return processRunner.getExecutor();
            }

            public RunContentDescriptor getContentDescriptor() {
                return processRunner.getContentDescriptor();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(true);
            }
        };
    }

    protected AnAction createStopAction() {
        return ActionManager.getInstance().getAction("Stop");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/play/console/ProcessLanguageConsoleViewWrapper", "<init>"));
    }
}

