/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.builder.renderer.BasicGraphNodeRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.seam.graph.beans.BasicPagesEdge;
import com.intellij.seam.graph.beans.BasicPagesNode;
import com.intellij.seam.graph.beans.ExceptionEdge;
import com.intellij.seam.graph.beans.ExceptionNode;
import com.intellij.seam.graph.beans.PageNode;
import com.intellij.seam.graph.renderers.DefaultPagesNodeRenderer;
import com.intellij.util.OpenSourceUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PagesPresentationModel
extends SelectionDependenciesPresentationModel<BasicPagesNode, BasicPagesEdge> {
    private final Project myProject;
    private BasicGraphNodeRenderer myRenderer;

    public PagesPresentationModel(Graph2D graph, Project project) {
        super((Graph)graph);
        this.myProject = project;
        this.setShowEdgeLabels(false);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(BasicPagesNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"PagesNodeRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            PagesPresentationModel.$$$reportNull$$$0(0);
        }
        return nodeRealizer;
    }

    public BasicGraphNodeRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new DefaultPagesNodeRenderer((GraphBuilder<BasicPagesNode, BasicPagesEdge>)this.getGraphBuilder());
        }
        return this.myRenderer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(BasicPagesEdge edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        boolean isExceptionEdge = edge instanceof ExceptionEdge;
        edgeRealizer.setLineType(isExceptionEdge ? LineType.DASHED_1 : LineType.LINE_1);
        edgeRealizer.setArrow(isExceptionEdge ? Arrow.DELTA : Arrow.STANDARD);
        edgeRealizer.setLineColor(Color.GRAY);
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            PagesPresentationModel.$$$reportNull$$$0(1);
        }
        return polyLineEdgeRealizer;
    }

    public boolean editNode(BasicPagesNode node) {
        XmlElement xmlElement = node.getIdentifyingElement().getXmlElement();
        if (xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editNode((Object)node);
    }

    public boolean editEdge(BasicPagesEdge pagesEdge) {
        XmlElement xmlElement = pagesEdge.getViewId().getXmlElement();
        if (xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editEdge((Object)pagesEdge);
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getNodeTooltip(BasicPagesNode node) {
        return node.getName();
    }

    public String getEdgeTooltip(BasicPagesEdge edge) {
        return edge.getName();
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowEdgeCreation(true);
        editMode.allowBendCreation(false);
        view.setFitContentOnResize(false);
        view.fitContent();
    }

    public DeleteProvider getDeleteProvider() {
        return new DeleteProvider<BasicPagesNode, BasicPagesEdge>(){

            public boolean canDeleteNode(@NotNull BasicPagesNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !((CellEditorMode)PagesPresentationModel.this.getGraphBuilder().getEditMode().getEditNodeMode()).isCellEditing();
            }

            public boolean canDeleteEdge(@NotNull BasicPagesEdge edge) {
                if (edge == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean deleteNode(final @NotNull BasicPagesNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                Collection edges = PagesPresentationModel.this.getGraphBuilder().getEdgeObjects();
                final ArrayList<BasicPagesEdge> deleteThis = new ArrayList<BasicPagesEdge>();
                for (BasicPagesEdge edge : edges) {
                    if (!edge.getSource().equals(node) && !edge.getTarget().equals(node)) continue;
                    deleteThis.add(edge);
                }
                new WriteCommandAction(PagesPresentationModel.this.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        node.getIdentifyingElement().undefine();
                        for (BasicPagesEdge edge : deleteThis) {
                            if (!edge.getViewId().isValid()) continue;
                            edge.getViewId().undefine();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PagesPresentationModel$1$1", "run"));
                    }
                }.execute();
                return true;
            }

            public boolean deleteEdge(final @NotNull BasicPagesEdge edge) {
                if (edge == null) {
                    1.$$$reportNull$$$0(3);
                }
                new WriteCommandAction(PagesPresentationModel.this.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        edge.getViewId().undefine();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PagesPresentationModel$1$2", "run"));
                    }
                }.execute();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "edge";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/seam/graph/PagesPresentationModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canDeleteNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canDeleteEdge";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deleteNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deleteEdge";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public NodeCellEditor getCustomNodeCellEditor(BasicPagesNode pagesNode) {
        return null;
    }

    public DefaultActionGroup getNodeActionGroup(BasicPagesNode pagesNode) {
        return super.getNodeActionGroup((Object)pagesNode);
    }

    public EdgeCreationPolicy<BasicPagesNode> getEdgeCreationPolicy() {
        return new EdgeCreationPolicy<BasicPagesNode>(){

            public boolean acceptSource(@NotNull BasicPagesNode source) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                return source instanceof PageNode || source instanceof ExceptionNode;
            }

            public boolean acceptTarget(@NotNull BasicPagesNode target) {
                if (target == null) {
                    2.$$$reportNull$$$0(1);
                }
                return !target.getName().contains("*") && !(target instanceof ExceptionNode);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/seam/graph/PagesPresentationModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptTarget";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/graph/PagesPresentationModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

