/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.fileEditor;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.dnd.ProjectViewDnDHelper;
import com.intellij.openapi.graph.builder.dnd.ProjectViewDnDSupport;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.graph.PagesDataModel;
import com.intellij.seam.graph.PagesPresentationModel;
import com.intellij.seam.graph.beans.BasicPagesEdge;
import com.intellij.seam.graph.beans.BasicPagesNode;
import com.intellij.seam.graph.dnd.PagesProjectViewDnDSupport;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PagesGraphComponent
extends JPanel
implements DataProvider,
Disposable {
    @NonNls
    public static final String SEAM_PAGEFLOW_DESIGNER_COMPONENT = "SEAM_PAGEFLOW_DESIGNER_COMPONENT";
    @NonNls
    private static final String SEAM_PAGEFLOW_DESIGNER_NAVIGATION_PROVIDER_NAME = "SEAM_PAGEFLOW_DESIGNER_NAVIGATION_PROVIDER_NAME";
    @NonNls
    private final SeamPagesGraphNavigationProvider myNavigationProvider = new SeamPagesGraphNavigationProvider();
    private final GraphBuilder<BasicPagesNode, BasicPagesEdge> myBuilder;
    private final XmlFile myXmlFile;
    private final PagesDataModel myDataModel;

    public PagesGraphComponent(XmlFile xmlFile) {
        this.myXmlFile = xmlFile;
        Project project = xmlFile.getProject();
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
        this.myDataModel = new PagesDataModel(xmlFile);
        PagesPresentationModel presentationModel = new PagesPresentationModel(graph, project);
        this.myBuilder = GraphBuilderFactory.getInstance((Project)project).createGraphBuilder(graph, view, (GraphDataModel)this.myDataModel, (GraphPresentationModel)presentationModel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbarPanel(), "North");
        this.add((Component)this.myBuilder.getView().getJComponent(), "Center");
        Disposer.register((Disposable)this, this.myBuilder);
        this.myBuilder.initialize();
        PagesGraphComponent.addDnDSupport(xmlFile, this.myBuilder);
        DomManager.getDomManager((Project)this.myBuilder.getProject()).addDomEventListener(new DomEventListener(){

            public void eventOccured(DomEvent event) {
                if (PagesGraphComponent.this.isShowing()) {
                    PagesGraphComponent.this.myBuilder.queueUpdate();
                }
            }
        }, (Disposable)this);
    }

    private static void addDnDSupport(XmlFile xmlFile, GraphBuilder<BasicPagesNode, BasicPagesEdge> builder) {
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)xmlFile.getContainingFile());
        if (webFacet != null) {
            ProjectViewDnDHelper.getInstance((Project)xmlFile.getProject()).addProjectViewDnDSupport(builder, (ProjectViewDnDSupport)new PagesProjectViewDnDSupport(xmlFile, builder, webFacet));
        }
    }

    private JComponent createToolbarPanel() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)GraphViewUtil.getBasicToolbar(this.myBuilder));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SeamPagesGraph", (ActionGroup)actions, true);
        return actionToolbar.getComponent();
    }

    public List<DomElement> getSelectedDomElements() {
        ArrayList<DomElement> selected = new ArrayList<DomElement>();
        Graph2D graph = this.myBuilder.getGraph();
        for (Node n : graph.getNodeArray()) {
            BasicPagesNode nodeObject;
            if (!graph.isSelected(n) || (nodeObject = (BasicPagesNode)this.myBuilder.getNodeObject(n)) == null) continue;
            ContainerUtil.addIfNotNull(selected, nodeObject.getIdentifyingElement());
        }
        return selected;
    }

    public void setSelectedDomElement(DomElement domElement) {
    }

    public GraphBuilder getBuilder() {
        return this.myBuilder;
    }

    public Overview getOverview() {
        return GraphManager.getGraphManager().createOverview(this.myBuilder.getView());
    }

    public void dispose() {
    }

    public SeamPagesGraphNavigationProvider getNavigationProvider() {
        return this.myNavigationProvider;
    }

    public XmlFile getXmlFile() {
        return this.myXmlFile;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (dataId.equals(SEAM_PAGEFLOW_DESIGNER_COMPONENT)) {
            return this;
        }
        return null;
    }

    public PagesDataModel getDataModel() {
        return this.myDataModel;
    }

    private class SeamPagesGraphNavigationProvider
    extends DomElementNavigationProvider {
        private SeamPagesGraphNavigationProvider() {
        }

        public String getProviderName() {
            return PagesGraphComponent.SEAM_PAGEFLOW_DESIGNER_NAVIGATION_PROVIDER_NAME;
        }

        public void navigate(DomElement domElement, boolean requestFocus) {
            PagesGraphComponent.this.setSelectedDomElement(domElement);
        }

        public boolean canNavigate(DomElement domElement) {
            return domElement.isValid();
        }
    }
}

