/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.undo;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.uml.UmlGraphBuilder;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class UmlRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    private final ArrayList<UmlGraphBuilder> myBuilders = new ArrayList();

    public void addBuilder(final UmlGraphBuilder builder) {
        this.myBuilders.add(builder);
        Disposer.register((Disposable)builder, (Disposable)new Disposable(){

            public void dispose() {
                UmlRefactoringElementListenerProvider.this.myBuilders.remove((Object)builder);
            }
        });
    }

    public RefactoringElementListener getListener(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        final Project project = element.getProject();
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (UmlGraphBuilder builder : this.myBuilders) {
            VirtualFile file = builder.getEditorFile();
            DiagramDataModel dataModel = builder.getDataModel();
            if (file == null || !dataModel.hasFile(psiFile)) continue;
            files.add(file);
        }
        return files.isEmpty() ? null : new RefactoringElementAdapter(){

            public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                CommandProcessor.getInstance().addAffectedFiles(project, VfsUtil.toVirtualFileArray((Collection)files));
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                if (newElement == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (oldQualifiedName == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldQualifiedName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/uml/undo/UmlRefactoringElementListenerProvider$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementRenamedOrMoved";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "undoElementMovedOrRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static UmlRefactoringElementListenerProvider getInstance(Project project) {
        UmlRefactoringElementListenerProvider instance = null;
        for (RefactoringElementListenerProvider provider : (RefactoringElementListenerProvider[])Extensions.getExtensions((ExtensionPointName)RefactoringElementListenerProvider.EP_NAME, (AreaInstance)project)) {
            if (!(provider instanceof UmlRefactoringElementListenerProvider)) continue;
            instance = (UmlRefactoringElementListenerProvider)provider;
            break;
        }
        assert (instance != null) : UmlRefactoringElementListenerProvider.class.getName() + " is not registered in plugin.xml";
        return instance;
    }
}

