/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project;

import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.UmlModulesUtils;
import com.intellij.uml.utils.UmlBundle;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.KeyStroke;

public class ModuleDependenciesProvider
implements DiagramElementsProvider<ModuleItem> {
    private static final Comparator<ModuleItem> COMPARATOR = (o1, o2) -> {
        if (o1.isLibrary() && o2.isModule()) {
            return 1;
        }
        if (o1.isModule() && o2.isLibrary()) {
            return -1;
        }
        return o1.getName().compareTo(o2.getName());
    };

    public ModuleItem[] getElements(ModuleItem element, Project project) {
        Module module = element.getModule();
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>();
        for (Module m : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            items.add(new ModuleItem(m));
        }
        for (Library library : UmlModulesUtils.getModuleLibraries(module)) {
            items.add(new ModuleItem(library, project));
        }
        return items.toArray(new ModuleItem[items.size()]);
    }

    public String getName() {
        return UmlBundle.message("show.modules.dependencies", new Object[0]);
    }

    public String getHeaderName(ModuleItem element, Project project) {
        return UmlBundle.message("dependencies.for.module", element.getName());
    }

    public ShortcutSet getShortcutSet() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0));
    }

    public Comparator<? super ModuleItem> getComparator() {
        return COMPARATOR;
    }

    public boolean showProgress() {
        return true;
    }

    public String getProgressMessage() {
        return UmlBundle.message("looking.for.dependencies", new Object[0]);
    }

    public boolean isEnabledOn(ModuleItem element) {
        return element.isModule();
    }
}

