/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.editors;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.uml.editors.DiagramNodeCellEditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeEditorManager
implements DataProvider {
    private static final DiagramNodeEditorManager INSTANCE = new DiagramNodeEditorManager();
    private JList currentContainer;
    private DiagramNodeCellEditor currentCellEditor;

    private DiagramNodeEditorManager() {
    }

    public static DiagramNodeEditorManager getInstance() {
        return INSTANCE;
    }

    public NodeCellEditor getCurrentCellEditor() {
        return this.currentCellEditor;
    }

    public void setCurrentCellEditor(@Nullable AbstractCellEditor editor, final @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(0);
        }
        if (editor instanceof DiagramNodeCellEditor) {
            this.currentCellEditor = (DiagramNodeCellEditor)editor;
        } else {
            this.currentCellEditor = null;
            this.currentContainer = null;
        }
        this.currentContainer = this.getCurrentContainer();
        if (this.currentContainer != null) {
            this.currentContainer.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        DiagramNodeEditorManager.this.stopEditing(builder);
                    }
                }
            });
            this.currentContainer.setSelectedIndex(0);
            IdeFocusManager.getInstance((Project)builder.getProject()).requestFocus((FocusCommand)new UmlFocusCommand(this.currentContainer), true);
        }
    }

    @Nullable
    private JList getCurrentContainer() {
        if (this.currentCellEditor != null) {
            return (JList)DiagramNodeEditorManager.findComponent(this.currentCellEditor.getEditor(), DiagramNodeBodyComponent.class);
        }
        return null;
    }

    public Object getData(@NonNls String dataId) {
        Object value = this.getCurrentValue();
        if (value == null) {
            return null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && value instanceof PsiElement && ((PsiElement)value).isPhysical()) {
            return value;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && value instanceof Navigatable) {
            return value;
        }
        return null;
    }

    public Object getCurrentValue() {
        JList editor = this.currentContainer;
        return editor == null ? null : editor.getSelectedValue();
    }

    @Nullable
    private static <T extends JComponent> T findComponent(JComponent parent, Class<T> cls) {
        if (parent == null || parent.getClass() == cls) {
            return (T)parent;
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = DiagramNodeEditorManager.findComponent((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    public void stopEditing(DiagramBuilder builder) {
        if (this.currentCellEditor != null) {
            this.currentCellEditor.stopCellEditing();
        }
        JComponent canvas = builder.getView().getCanvasComponent();
        IdeFocusManager.getInstance((Project)builder.getProject()).requestFocus((FocusCommand)new UmlFocusCommand(canvas), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/uml/editors/DiagramNodeEditorManager", "setCurrentCellEditor"));
    }

    private static class UmlFocusCommand
    extends FocusCommand.ByComponent {
        public UmlFocusCommand(@Nullable Component toFocus) {
            super(toFocus, (Throwable)new Exception());
        }

        public boolean isExpired() {
            return false;
        }
    }
}

