/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcshLauncher {
    private static final int[] FLEX_4_SDK_BUILDS_THAT_HAVE_FIX = new int[]{0};
    private static final int[] FLEX_45_SDK_BUILDS_THAT_HAVE_FIX = new int[]{0};

    public static void main(String[] args) {
        try {
            String flexSdkVersion = FcshLauncher.getFlexSdkVersion();
            if (flexSdkVersion == null) {
                FcshLauncher.launchFcshWithoutFix(args);
            } else {
                FcshLauncher.launchFcshWithFix(flexSdkVersion, args);
            }
        }
        catch (OutOfMemoryError oomError) {
            System.out.println("(fcsh) out of memory");
            System.exit(0);
        }
    }

    private static void launchFcshWithoutFix(String[] args) {
        Class entryPointClass = FcshLauncher.findClass("flex2.tools.Fcsh");
        if (entryPointClass == null) {
            entryPointClass = FcshLauncher.findClass("flex2.tools.SimpleShell");
        }
        if (entryPointClass != null) {
            try {
                Method main = entryPointClass.getMethod("main", args.getClass());
                main.invoke(null, new Object[]{args});
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof VirtualMachineError) {
                    throw (VirtualMachineError)e.getCause();
                }
                e.printStackTrace();
            }
        } else {
            System.err.println("Flex SDK is corrupted.");
        }
    }

    private static void launchFcshWithFix(String flexSdkVersion, String[] args) {
        Class entryPointClass = FcshLauncher.getEntryPointClass(flexSdkVersion);
        if (entryPointClass == null) {
            FcshLauncher.launchFcshWithoutFix(args);
        } else {
            try {
                Method main = entryPointClass.getMethod("main", args.getClass());
                try {
                    main.invoke(null, new Object[]{args});
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof VirtualMachineError) {
                        throw (VirtualMachineError)e.getCause();
                    }
                    throw e;
                }
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable t) {
                System.out.println("(fcsh) need to repeat command");
                FcshLauncher.launchFcshWithoutFix(args);
            }
        }
    }

    private static Class getEntryPointClass(String flexSdkVersion) {
        if (flexSdkVersion.startsWith("3")) {
            return FcshLauncher.findClass("com.intellij.flex.SimpleShellWithFix");
        }
        if (flexSdkVersion.startsWith("4")) {
            if (flexSdkVersion.startsWith("4.0") || flexSdkVersion.startsWith("4.1")) {
                return FcshLauncher.getFcshWithFixClass(flexSdkVersion, "com.intellij.flex.Fcsh4WithFix", FLEX_4_SDK_BUILDS_THAT_HAVE_FIX);
            }
            if (flexSdkVersion.startsWith("4.5") || flexSdkVersion.startsWith("4.6")) {
                return FcshLauncher.getFcshWithFixClass(flexSdkVersion, "com.intellij.flex.Fcsh45WithFix", FLEX_45_SDK_BUILDS_THAT_HAVE_FIX);
            }
        }
        return null;
    }

    private static Class getFcshWithFixClass(String flexSdkVersion, String classNamePrefix, int[] sdkBuildsThatHaveFix) {
        try {
            int build = Integer.parseInt(flexSdkVersion.substring(flexSdkVersion.indexOf(" build ") + " build ".length()));
            if (build == 0) {
                System.out.println("Warning: Flex SDK build can not be 0.");
            } else {
                for (int i = 0; i < sdkBuildsThatHaveFix.length; ++i) {
                    int buildWithFix = sdkBuildsThatHaveFix[i];
                    if (sdkBuildsThatHaveFix.length != i + 1 && build >= sdkBuildsThatHaveFix[i + 1]) continue;
                    return FcshLauncher.findClass(classNamePrefix + buildWithFix);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static String getFlexSdkVersion() {
        String version = FcshLauncher.readVersionUsingAPI();
        if (!FcshLauncher.checkFlexSdkVersion(version)) {
            version = FcshLauncher.readVersionFromFlexSdkDescriptionXml();
        }
        return FcshLauncher.checkFlexSdkVersion(version) ? version : null;
    }

    private static boolean checkFlexSdkVersion(String flexSdkVersion) {
        return flexSdkVersion != null && flexSdkVersion.matches("[0-9][.][0-9].* build [0-9]+");
    }

    private static String readVersionUsingAPI() {
        String version = null;
        try {
            Class versionInfoClass = FcshLauncher.findClass("flex2.tools.VersionInfo");
            Method buildMessageMethod = versionInfoClass == null ? null : versionInfoClass.getMethod("buildMessage", new Class[0]);
            String string = version = buildMessageMethod == null ? null : (String)buildMessageMethod.invoke(null, new Object[0]);
            if (version != null && version.startsWith("Version ")) {
                version = version.substring("Version ".length());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readVersionFromFlexSdkDescriptionXml() {
        String string;
        String flexSdkHome = System.getProperty("application.home");
        if (flexSdkHome == null) {
            return null;
        }
        File flexSdkDescriptionFile = new File(flexSdkHome + File.separatorChar + "flex-sdk-description.xml");
        if (!flexSdkDescriptionFile.exists()) {
            return null;
        }
        String versionElement = "<flex-sdk-description><version>";
        String buildElement = "<flex-sdk-description><build>";
        FileInputStream xmlInputStream = null;
        try {
            xmlInputStream = new FileInputStream(flexSdkDescriptionFile);
            Map<String, List<String>> versionInfo = FcshLauncher.findXMLElements(xmlInputStream, Arrays.asList("<flex-sdk-description><version>", "<flex-sdk-description><build>"));
            string = (versionInfo.get("<flex-sdk-description><version>").isEmpty() ? null : versionInfo.get("<flex-sdk-description><version>").get(0)) + (versionInfo.get("<flex-sdk-description><build>").isEmpty() ? "" : " build " + versionInfo.get("<flex-sdk-description><build>").get(0));
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                FcshLauncher.close(xmlInputStream);
                throw throwable;
            }
            FcshLauncher.close(xmlInputStream);
            return string2;
        }
        FcshLauncher.close(xmlInputStream);
        return string;
    }

    private static Map<String, List<String>> findXMLElements(InputStream xmlInputStream, final List<String> xmlElements) {
        final HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        for (String element : xmlElements) {
            resultMap.put(element, new ArrayList());
        }
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(xmlInputStream, new DefaultHandler(){
                private String currentElement = "";
                private StringBuilder currentElementContent = new StringBuilder();

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    this.currentElement = this.currentElement + "<" + qName + ">";
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (xmlElements.contains(this.currentElement)) {
                        ((List)resultMap.get(this.currentElement)).add(this.currentElementContent.toString());
                        this.currentElementContent.delete(0, this.currentElementContent.length());
                    }
                    assert (this.currentElement.endsWith("<" + qName + ">"));
                    this.currentElement = this.currentElement.substring(0, this.currentElement.length() - (qName.length() + 2));
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (xmlElements.contains(this.currentElement)) {
                        this.currentElementContent.append(ch, start, length);
                    }
                }
            });
        }
        catch (SAXException ignored) {
        }
        catch (IOException ignored) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return resultMap;
    }

    private static Class findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

