/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxRenameFxIdFieldProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        NestedControllerCandidate nestedControllerCandidate;
        Collection<PsiFile> fxmls;
        if (element == null) {
            JavaFxRenameFxIdFieldProcessor.$$$reportNull$$$0(0);
        }
        return !(fxmls = JavaFxRenameFxIdFieldProcessor.findFxmlWithController(nestedControllerCandidate = JavaFxRenameFxIdFieldProcessor.findNestedControllerCandidate(element))).isEmpty();
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        final NestedControllerCandidate nestedControllerCandidate = JavaFxRenameFxIdFieldProcessor.findNestedControllerCandidate(element);
        if (nestedControllerCandidate != null) {
            Collection<PsiFile> fxmls = JavaFxRenameFxIdFieldProcessor.findFxmlWithController(nestedControllerCandidate);
            for (PsiFile fxml : fxmls) {
                final Ref found = new Ref((Object)false);
                fxml.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        if (((Boolean)found.get()).booleanValue()) {
                            return;
                        }
                        if ("fx:include".equals(tag.getName())) {
                            String value = tag.getAttributeValue("fx:id");
                            if (StringUtil.equals((CharSequence)nestedControllerCandidate.fxId, (CharSequence)value)) {
                                found.set((Object)true);
                            }
                        }
                    }
                });
                if (!((Boolean)found.get()).booleanValue()) continue;
                allRenames.put((PsiElement)nestedControllerCandidate.nestedControllerField, newName + "Controller");
                return;
            }
        }
    }

    @Nullable
    private static NestedControllerCandidate findNestedControllerCandidate(@NotNull PsiElement element) {
        PsiType psiType;
        PsiField nestedControllerField;
        PsiClass containingClass;
        PsiField field;
        String fxId;
        if (element == null) {
            JavaFxRenameFxIdFieldProcessor.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiField && !StringUtil.isEmpty((String)(fxId = (field = (PsiField)element).getName())) && (containingClass = field.getContainingClass()) != null && (nestedControllerField = containingClass.findFieldByName(fxId + "Controller", true)) != null && !((psiType = nestedControllerField.getType()) instanceof PsiPrimitiveType) && !(psiType instanceof PsiArrayType)) {
            return new NestedControllerCandidate(fxId, nestedControllerField, containingClass);
        }
        return null;
    }

    @NotNull
    private static Collection<PsiFile> findFxmlWithController(@Nullable NestedControllerCandidate nestedControllerCandidate) {
        String qualifiedName;
        if (nestedControllerCandidate != null && (qualifiedName = nestedControllerCandidate.controllerClass.getQualifiedName()) != null) {
            Project project = nestedControllerCandidate.controllerClass.getProject();
            List<PsiFile> list = JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName);
            if (list == null) {
                JavaFxRenameFxIdFieldProcessor.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PsiFile> list = Collections.emptyList();
        if (list == null) {
            JavaFxRenameFxIdFieldProcessor.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findFxmlWithController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findNestedControllerCandidate";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NestedControllerCandidate {
        private final String fxId;
        private final PsiField nestedControllerField;
        private final PsiClass controllerClass;

        private NestedControllerCandidate(@NotNull String fxId, @NotNull PsiField nestedControllerField, @NotNull PsiClass controllerClass) {
            if (fxId == null) {
                NestedControllerCandidate.$$$reportNull$$$0(0);
            }
            if (nestedControllerField == null) {
                NestedControllerCandidate.$$$reportNull$$$0(1);
            }
            if (controllerClass == null) {
                NestedControllerCandidate.$$$reportNull$$$0(2);
            }
            this.fxId = fxId;
            this.nestedControllerField = nestedControllerField;
            this.controllerClass = controllerClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fxId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nestedControllerField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "controllerClass";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameFxIdFieldProcessor$NestedControllerCandidate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

