/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxPropertyAttributeDescriptor
extends BasicXmlAttributeDescriptor {
    private final String myName;
    private final PsiClass myPsiClass;

    public JavaFxPropertyAttributeDescriptor(String name, PsiClass psiClass) {
        this.myName = name;
        this.myPsiClass = psiClass;
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public boolean isEnumerated() {
        return this.getEnumeratedValues() != null;
    }

    @Nullable
    public String[] getEnumeratedValues() {
        PsiClass aClass = this.getEnum();
        if (aClass != null) {
            PsiField[] fields = aClass.getAllFields();
            ArrayList<String> enumConstants = new ArrayList<String>();
            for (PsiField enumField : fields) {
                if (!this.isConstant(enumField)) continue;
                enumConstants.add(enumField.getName());
            }
            return ArrayUtil.toStringArray(enumConstants);
        }
        String propertyQName = JavaFxPsiUtil.getBoxedPropertyType(this.myPsiClass, this.getDeclarationMember());
        if ("java.lang.Float".equals(propertyQName) || "java.lang.Double".equals(propertyQName)) {
            return new String[]{"Infinity", "-Infinity", "NaN", "-NaN"};
        }
        if ("java.lang.Boolean".equals(propertyQName)) {
            return new String[]{"true", "false"};
        }
        return null;
    }

    protected boolean isConstant(PsiField field) {
        return field instanceof PsiEnumConstant;
    }

    protected PsiClass getEnum() {
        PsiClass aClass = JavaFxPsiUtil.getPropertyClass(this.getDeclaration());
        return aClass != null && aClass.isEnum() ? aClass : null;
    }

    public PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        if (value != null && value.startsWith("%")) {
            return xmlElement;
        }
        PsiClass aClass = this.getEnum();
        if (aClass != null) {
            PsiField fieldByName = aClass.findFieldByName(value, true);
            return fieldByName != null ? fieldByName : aClass.findFieldByName(value.toUpperCase(), true);
        }
        return xmlElement;
    }

    @Nullable
    public String validateValue(XmlElement context, String value) {
        if (context instanceof XmlAttributeValue && value != null) {
            return this.validateAttributeValue((XmlAttributeValue)context, value);
        }
        return null;
    }

    @Nullable
    protected String validateAttributeValue(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
        PsiElement parent;
        if (xmlAttributeValue == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(0);
        }
        if (value == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(1);
        }
        if ((parent = xmlAttributeValue.getParent()) instanceof XmlAttribute && JavaFxPsiUtil.isEventHandlerProperty((XmlAttribute)parent)) {
            return JavaFxPropertyAttributeDescriptor.validateAttributeHandler((XmlElement)xmlAttributeValue, value);
        }
        if (value.startsWith("$")) {
            return JavaFxPropertyAttributeDescriptor.validatePropertyExpression(xmlAttributeValue, value);
        }
        if (StringUtil.trimLeading((String)value).startsWith("$")) {
            return "Spaces aren't allowed before property or expression";
        }
        if (value.startsWith("%")) {
            return null;
        }
        return JavaFxPropertyAttributeDescriptor.validateLiteral(xmlAttributeValue, value);
    }

    @Nullable
    private static String validateAttributeHandler(@NotNull XmlElement context, @NotNull String value) {
        if (context == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(2);
        }
        if (value == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(3);
        }
        if (value.startsWith("#")) {
            if (JavaFxPsiUtil.getControllerClass(context.getContainingFile()) == null) {
                return "No controller specified for top level element";
            }
        } else if (JavaFxPsiUtil.parseInjectedLanguages((XmlFile)context.getContainingFile()).isEmpty()) {
            return "Page language not specified.";
        }
        return null;
    }

    @Nullable
    private static String validatePropertyExpression(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
        List propertyNames;
        if (xmlAttributeValue == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(4);
        }
        if (value == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(5);
        }
        if (JavaFxPsiUtil.isIncorrectExpressionBinding(value)) {
            return "Incorrect expression syntax";
        }
        List list = propertyNames = JavaFxPsiUtil.isExpressionBinding(value) ? StringUtil.split((String)value.substring(2, value.length() - 1), (String)".", (boolean)true, (boolean)false) : Collections.singletonList(value.substring(1));
        if (JavaFxPropertyAttributeDescriptor.isIncompletePropertyChain(propertyNames)) {
            return "Incorrect expression syntax";
        }
        if ("${null}".equals(value)) {
            return null;
        }
        XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlTag.class);
        PsiType targetPropertyType = JavaFxPsiUtil.getWritablePropertyType(xmlAttributeValue);
        if (FxmlConstants.isNullValue(value)) {
            if (JavaFxPsiUtil.isPrimitiveOrBoxed(targetPropertyType)) {
                return "Unable to coerce to " + targetPropertyType.getPresentableText();
            }
            return null;
        }
        PsiClass targetPropertyClass = JavaFxPsiUtil.getPropertyClass(targetPropertyType, (PsiElement)xmlAttributeValue);
        if (targetPropertyClass == null || JavaFxPsiUtil.hasConversionFromAnyType(targetPropertyClass)) {
            return null;
        }
        String firstPropertyName = (String)propertyNames.get(0);
        Map<String, XmlAttributeValue> fileIds = JavaFxPsiUtil.collectFileIds(currentTag);
        PsiClass tagClass = JavaFxPsiUtil.getTagClassById(fileIds.get(firstPropertyName), firstPropertyName, (PsiElement)xmlAttributeValue);
        if (tagClass != null) {
            PsiClass aClass = tagClass;
            List remainingPropertyNames = propertyNames.subList(1, propertyNames.size());
            for (String propertyName : remainingPropertyNames) {
                if (aClass == null) break;
                PsiMember member = JavaFxPsiUtil.getReadableProperties(aClass).get(propertyName);
                aClass = JavaFxPsiUtil.getPropertyClass(JavaFxPsiUtil.getReadablePropertyType((PsiElement)member), (PsiElement)xmlAttributeValue);
            }
            if (aClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)targetPropertyClass, (boolean)true)) {
                return "Invalid value: unable to coerce to " + targetPropertyClass.getQualifiedName();
            }
        }
        return null;
    }

    public static boolean isIncompletePropertyChain(@NotNull List<String> propertyNames) {
        if (propertyNames == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(6);
        }
        return propertyNames.isEmpty() || propertyNames.contains("");
    }

    @Nullable
    protected static String validateLiteral(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
        if (xmlAttributeValue == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(7);
        }
        if (value == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(8);
        }
        PsiClass tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue);
        PsiElement declaration = JavaFxPsiUtil.getAttributeDeclaration(xmlAttributeValue);
        String boxedQName = declaration != null ? (declaration instanceof PsiMember ? JavaFxPsiUtil.getBoxedPropertyType(tagClass, (PsiMember)declaration) : null) : (tagClass != null && !InheritanceUtil.isInheritor((PsiClass)tagClass, (boolean)false, (String)"javafx.scene.Node") ? tagClass.getQualifiedName() : null);
        if (boxedQName != null) {
            try {
                Class<?> aClass = Class.forName(boxedQName);
                Method method = aClass.getMethod("valueOf", String.class);
                method.invoke(aClass, value);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NumberFormatException) {
                    PsiClass resolvedClass;
                    PsiElement resolve;
                    PsiReference reference = xmlAttributeValue.getReference();
                    if (reference != null && (resolve = reference.resolve()) instanceof XmlAttributeValue && (resolvedClass = JavaFxPsiUtil.getTagClass((XmlAttributeValue)resolve)) != null && boxedQName.equals(resolvedClass.getQualifiedName())) {
                        return null;
                    }
                    return "Invalid value: unable to coerce to " + boxedQName;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String validateLiteralOrEnumConstant(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value) {
        PsiClass aClass;
        XmlAttributeDescriptor descriptor;
        PsiElement parent;
        if (xmlAttributeValue == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(9);
        }
        if (value == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(10);
        }
        if ((parent = xmlAttributeValue.getParent()) instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) instanceof JavaFxPropertyAttributeDescriptor && (aClass = ((JavaFxPropertyAttributeDescriptor)descriptor).getEnum()) != null) {
            PsiField field = aClass.findFieldByName(value, true);
            if (field == null || !((JavaFxPropertyAttributeDescriptor)descriptor).isConstant(field)) {
                return "Invalid enumerated value";
            }
            return null;
        }
        return JavaFxPropertyAttributeDescriptor.validateLiteral(xmlAttributeValue, value);
    }

    public PsiElement getDeclaration() {
        return this.getDeclarationMember();
    }

    private PsiMember getDeclarationMember() {
        return JavaFxPsiUtil.getWritableProperties(this.myPsiClass).get(this.myName);
    }

    public PsiReference[] getValueReferences(XmlElement element, @NotNull String text) {
        if (text == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(11);
        }
        return !text.startsWith("${") && !FxmlConstants.isNullValue(text) ? super.getValueReferences(element, text) : PsiReference.EMPTY_ARRAY;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JavaFxPropertyAttributeDescriptor.$$$reportNull$$$0(12);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public String toString() {
        return (this.myPsiClass != null ? this.myPsiClass.getName() + "#" : "?#") + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttributeValue";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxPropertyAttributeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxPropertyAttributeDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateAttributeValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateAttributeHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validatePropertyExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIncompletePropertyChain";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateLiteral";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateLiteralOrEnumConstant";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueReferences";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

