/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticSetterAttributeDescriptor;

public class JavaFxBuiltInTagDescriptor
implements XmlElementDescriptor,
Validator<XmlTag> {
    private final String myName;
    private final XmlTag myXmlTag;

    public JavaFxBuiltInTagDescriptor(String name, XmlTag tag) {
        this.myName = name;
        this.myXmlTag = tag;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        if ("fx:define".equals(this.myName)) {
            return JavaFxClassTagDescriptorBase.createTagDescriptor(childTag);
        }
        return null;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        XmlElementDescriptor includedRootDescriptor;
        XmlTag includedRoot;
        XmlAttributeDescriptor[] attributesDescriptors;
        XmlElementDescriptor referencedDescriptor;
        ArrayList<XmlAttributeDescriptor> descriptors = new ArrayList<XmlAttributeDescriptor>();
        List<String> builtInAttributeNames = FxmlConstants.FX_BUILT_IN_TAG_SUPPORTED_ATTRIBUTES.get(this.getName());
        if (builtInAttributeNames != null) {
            for (String attrName : builtInAttributeNames) {
                descriptors.add((XmlAttributeDescriptor)JavaFxBuiltInAttributeDescriptor.create(attrName, this.getName()));
            }
        }
        JavaFxClassTagDescriptorBase.collectStaticAttributesDescriptors(context, descriptors);
        XmlTag referencedTag = JavaFxBuiltInTagDescriptor.getReferencedTag(this.myXmlTag);
        if (referencedTag != null && (referencedDescriptor = referencedTag.getDescriptor()) != null && (attributesDescriptors = referencedDescriptor.getAttributesDescriptors(referencedTag)) != null) {
            Collections.addAll(descriptors, attributesDescriptors);
        }
        if ((includedRoot = JavaFxBuiltInTagDescriptor.getIncludedRoot(context)) != null && (includedRootDescriptor = includedRoot.getDescriptor()) instanceof JavaFxClassTagDescriptorBase) {
            ((JavaFxClassTagDescriptorBase)includedRootDescriptor).collectInstanceProperties(descriptors);
        }
        return descriptors.isEmpty() ? XmlAttributeDescriptor.EMPTY : descriptors.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        List<String> defaultAttributeList = FxmlConstants.FX_BUILT_IN_TAG_SUPPORTED_ATTRIBUTES.get(this.getName());
        if (defaultAttributeList != null) {
            XmlElementDescriptor includedRootDescriptor;
            XmlTag includedRoot;
            XmlElementDescriptor referencedDescriptor;
            if (defaultAttributeList.contains(attributeName)) {
                return JavaFxBuiltInAttributeDescriptor.create(attributeName, this.getName());
            }
            PsiMethod propertySetter = JavaFxPsiUtil.findStaticPropertySetter(attributeName, context);
            if (propertySetter != null) {
                return new JavaFxStaticSetterAttributeDescriptor(propertySetter, attributeName);
            }
            XmlTag referencedTag = JavaFxBuiltInTagDescriptor.getReferencedTag(this.myXmlTag);
            if (referencedTag != null && (referencedDescriptor = referencedTag.getDescriptor()) != null) {
                return referencedDescriptor.getAttributeDescriptor(attributeName, referencedTag);
            }
            if (context != null && "fx:include".equals(this.getName()) && (includedRoot = JavaFxBuiltInTagDescriptor.getIncludedRoot(context)) != null && (includedRootDescriptor = includedRoot.getDescriptor()) != null) {
                return includedRootDescriptor.getAttributeDescriptor(attributeName, includedRoot);
            }
        }
        return null;
    }

    @Nullable
    public static XmlTag getReferencedTag(XmlTag tag) {
        PsiElement resolve;
        PsiReference reference;
        XmlAttributeValue valueElement;
        XmlAttribute attribute;
        String tagName = tag.getName();
        if (("fx:reference".equals(tagName) || "fx:copy".equals(tagName)) && (attribute = tag.getAttribute("source")) != null && (valueElement = attribute.getValueElement()) != null && (reference = valueElement.getReference()) != null && (resolve = reference.resolve()) instanceof XmlAttributeValue) {
            return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)resolve, XmlTag.class);
        }
        return null;
    }

    public static XmlTag getIncludedRoot(XmlTag context) {
        XmlTag rootTag;
        PsiElement resolve;
        PsiReference reference;
        XmlAttributeValue valueElement;
        if (context == null) {
            return null;
        }
        XmlAttribute xmlAttribute = context.getAttribute("source");
        if (xmlAttribute != null && (valueElement = xmlAttribute.getValueElement()) != null && (reference = valueElement.getReference()) != null && (resolve = reference.resolve()) instanceof XmlFile && (rootTag = ((XmlFile)resolve).getRootTag()) != null) {
            return rootTag;
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myXmlTag;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JavaFxBuiltInTagDescriptor.$$$reportNull$$$0(0);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        PsiElement declaration;
        XmlElementDescriptor descriptor;
        XmlTag referencedTag;
        if (context == null) {
            JavaFxBuiltInTagDescriptor.$$$reportNull$$$0(1);
        }
        if (host == null) {
            JavaFxBuiltInTagDescriptor.$$$reportNull$$$0(2);
        }
        if ((referencedTag = JavaFxBuiltInTagDescriptor.getReferencedTag(context)) != null && (descriptor = referencedTag.getDescriptor()) != null && (declaration = descriptor.getDeclaration()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)declaration;
            JavaFxPsiUtil.isClassAcceptable(context.getParentTag(), psiClass, (errorMessage, errorType) -> {
                if (host == null) {
                    JavaFxBuiltInTagDescriptor.$$$reportNull$$$0(3);
                }
                if (context == null) {
                    JavaFxBuiltInTagDescriptor.$$$reportNull$$$0(4);
                }
                host.addMessage(context.getNavigationElement(), errorMessage, errorType);
            });
            String contextName = context.getName();
            if ("fx:copy".equals(contextName)) {
                boolean copyConstructorFound = false;
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    PsiParameter[] parameters = constructor.getParameterList().getParameters();
                    if (parameters.length != 1 || psiClass != PsiUtil.resolveClassInType((PsiType)parameters[0].getType())) continue;
                    copyConstructorFound = true;
                    break;
                }
                if (!copyConstructorFound) {
                    host.addMessage(context.getNavigationElement(), "Copy constructor not found for '" + psiClass.getName() + "'", Validator.ValidationHost.ErrorType.ERROR);
                }
            }
        }
    }

    public String toString() {
        String source = this.myXmlTag != null ? this.myXmlTag.getAttributeValue("source") : null;
        return "<" + this.myName + (source != null ? " -> " + source : "") + ">";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInTagDescriptor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependences";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxBuiltInTagDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$validate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

