/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.search;

import com.intellij.lang.aspectj.index.stub.AjShortClassNameIndex;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjClassFinder
extends PsiElementFinder {
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        String shortName;
        Project project;
        if (qualifiedName == null) {
            AjClassFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            AjClassFinder.$$$reportNull$$$0(1);
        }
        if ((project = scope.getProject()) != null && (shortName = AjClassFinder.getShortName(qualifiedName)) != null) {
            Collection<PsiInterTypeClass> classes = AjShortClassNameIndex.getInstance().get(shortName, project, scope);
            for (PsiInterTypeClass aClass : classes) {
                if (!qualifiedName.equals(aClass.getQualifiedName())) continue;
                return aClass;
            }
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Collection<PsiInterTypeClass> classes;
        String shortName;
        Project project;
        if (qualifiedName == null) {
            AjClassFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            AjClassFinder.$$$reportNull$$$0(3);
        }
        if ((project = scope.getProject()) != null && (shortName = AjClassFinder.getShortName(qualifiedName)) != null && !(classes = AjShortClassNameIndex.getInstance().get(shortName, project, scope)).isEmpty()) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiInterTypeClass aClass : classes) {
                if (!qualifiedName.equals(aClass.getQualifiedName())) continue;
                result.add(aClass);
            }
            int count = result.size();
            if (count > 0) {
                PsiClass[] psiClassArray = result.toArray(new PsiClass[count]);
                if (psiClassArray == null) {
                    AjClassFinder.$$$reportNull$$$0(4);
                }
                return psiClassArray;
            }
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            AjClassFinder.$$$reportNull$$$0(5);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    private static String getShortName(@NotNull String qName) {
        int pos;
        if (qName == null) {
            AjClassFinder.$$$reportNull$$$0(6);
        }
        return (pos = qName.lastIndexOf(46)) >= 0 && pos < qName.length() - 1 ? qName.substring(pos + 1) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/search/AjClassFinder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/search/AjClassFinder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

