/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.ref;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.AnnotationUtil;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiTypeElement;

public class WrongTargetAnnotator
extends ElementAnnotator<PsiJavaCodeReferenceElement> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiJavaCodeReferenceElement element) {
        PsiElement type = element.getParent();
        if (!(type instanceof PsiTypeElement)) {
            return false;
        }
        PsiElement typeRef = type.getParent();
        if (!(typeRef instanceof PsiInterTypeReference)) {
            return false;
        }
        PsiElement member = typeRef.getParent();
        if (!(member instanceof PsiMember)) {
            return false;
        }
        PsiElement target = element.resolve();
        if (!(target instanceof PsiClass)) {
            return false;
        }
        PsiClass targetClass = (PsiClass)target;
        if (targetClass.isEnum()) {
            TextRange range = AnnotationUtil.memberRange((PsiMember)member);
            holder.createErrorAnnotation(range, AspectJBundle.message("highlighting.target.enum", new Object[0]));
            return true;
        }
        if (targetClass.isInterface() && member instanceof PsiInterTypeClass) {
            TextRange range = AnnotationUtil.memberRange((PsiMember)member);
            holder.createErrorAnnotation(range, AspectJBundle.message("highlighting.target.interface", new Object[0]));
            return true;
        }
        return false;
    }
}

