/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.lang.aspectj.AspectJFileType;
import com.intellij.lang.aspectj.debug.AspectJDebugUtil;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AspectJPositionManager
implements PositionManager {
    private final DebugProcess myDebugProcess;
    private static final Set<FileType> ourFileTypes = Collections.singleton(AspectJFileType.INSTANCE);

    public AspectJPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        String signature;
        PsiFile psiFile;
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        int lineNumber = DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true);
        PsiClass psiClass = AspectJDebugUtil.findClassByLocation(location, this.myDebugProcess.getProject(), this.myDebugProcess.getSearchScope());
        PsiFile psiFile2 = psiFile = psiClass != null ? psiClass.getNavigationElement().getContainingFile() : null;
        if (psiFile instanceof PsiAspectJFile) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        }
        if (psiFile instanceof PsiJavaFile && lineNumber == 0 && (signature = location.method().signature()) != null) {
            try {
                for (PsiMethod candidate : psiClass.findMethodsByName(location.method().name(), false)) {
                    if (!(candidate instanceof PsiInterTypeMethod) || !JVMNameUtil.getJVMSignature((PsiMethod)candidate).getName((DebugProcessImpl)this.myDebugProcess).equals(signature)) continue;
                    return SourcePosition.createFromLine((PsiFile)candidate.getContainingFile(), (int)-1);
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        throw NoDataException.INSTANCE;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            AspectJPositionManager.$$$reportNull$$$0(0);
        }
        AspectJDebugUtil.checkDomain(position);
        AspectJDebugUtil.ClassData classData = AspectJDebugUtil.findClassAt(position);
        if (classData == null) {
            List<ReferenceType> list = Collections.emptyList();
            if (list == null) {
                AspectJPositionManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (classData.isTopLevel) {
            List list = this.myDebugProcess.getVirtualMachineProxy().classesByName(classData.topClassName);
            if (list == null) {
                AspectJPositionManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        List outers = this.myDebugProcess.getVirtualMachineProxy().classesByName(classData.topClassName);
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(outers.size());
        for (ReferenceType outer : outers) {
            ReferenceType nested = AspectJDebugUtil.findNestedClass(outer, classData.aClass, position, this.myDebugProcess.getVirtualMachineProxy());
            if (nested == null) continue;
            result.add(nested);
        }
        ArrayList<ReferenceType> arrayList = result;
        if (arrayList == null) {
            AspectJPositionManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        block6: {
            List<Location> list;
            if (type == null) {
                AspectJPositionManager.$$$reportNull$$$0(4);
            }
            if (position == null) {
                AspectJPositionManager.$$$reportNull$$$0(5);
            }
            AspectJDebugUtil.checkDomain(position);
            try {
                int line = position.getLine() + 1;
                List<Location> locations = type.locationsOfLine("Java", null, line);
                if (locations.size() <= 0) break block6;
                list = locations;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            if (list == null) {
                AspectJPositionManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            AspectJPositionManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            AspectJPositionManager.$$$reportNull$$$0(8);
        }
        if (position == null) {
            AspectJPositionManager.$$$reportNull$$$0(9);
        }
        AspectJDebugUtil.checkDomain(position);
        AspectJDebugUtil.ClassData classData = AspectJDebugUtil.findClassAt(position);
        if (classData == null) {
            return null;
        }
        if (classData.isTopLevel) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, classData.topClassName);
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                PositionManager positionManager = debuggerProcess.getPositionManager();
                try {
                    if (positionManager.locationsOfLine(referenceType, position).size() > 0) {
                        requestor.processClassPrepare(debuggerProcess, referenceType);
                    } else {
                        List positionClasses = positionManager.getAllClasses(position);
                        if (positionClasses.contains(referenceType)) {
                            requestor.processClassPrepare(debuggerProcess, referenceType);
                        }
                    }
                }
                catch (NoDataException noDataException) {
                    // empty catch block
                }
            }
        }, classData.topClassName + "$*");
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        Set<FileType> set = ourFileTypes;
        if (set == null) {
            AspectJPositionManager.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/debug/AspectJPositionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/debug/AspectJPositionManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

