/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.Nullable;

public class AspectJDebugUtil {
    private AspectJDebugUtil() {
    }

    public static void checkDomain(SourcePosition position) throws NoDataException {
        if (!(position.getFile() instanceof PsiAspectJFile)) {
            throw NoDataException.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ClassData findClassAt(SourcePosition position) {
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            PsiClass topClass;
            PsiElement element = position.getFile().getViewProvider().findElementAt(position.getOffset());
            if (element == null) {
                ClassData classData = null;
                return classData;
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (psiClass == null) {
                ClassData classData = null;
                return classData;
            }
            if (!PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
                ClassData classData = new ClassData(psiClass, true, JVMNameUtil.getNonAnonymousClassName((PsiClass)psiClass));
                return classData;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiMethod.class, (boolean)true);
            PsiClass psiClass2 = topClass = method instanceof PsiInterTypeMethod ? method.getContainingClass() : JVMNameUtil.getTopLevelParentClass((PsiClass)psiClass);
            if (topClass != null) {
                ClassData classData = new ClassData(psiClass, false, JVMNameUtil.getNonAnonymousClassName((PsiClass)topClass));
                return classData;
            }
            ClassData classData = null;
            return classData;
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    public static PsiClass findClassByLocation(Location location, Project project, GlobalSearchScope searchScope) {
        if (location == null || DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalName = refType.name();
        int buck = originalName.indexOf(36);
        String topLevelName = buck >= 0 ? originalName.substring(0, buck) : originalName;
        PsiClass psiClass = DebuggerUtils.findClass((String)topLevelName, (Project)project, (GlobalSearchScope)searchScope);
        if (psiClass == null && buck >= 0) {
            psiClass = DebuggerUtils.findClass((String)originalName, (Project)project, (GlobalSearchScope)searchScope);
        }
        return psiClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ReferenceType findNestedClass(ReferenceType outer, PsiClass aClass, SourcePosition position, VirtualMachineProxy vmProxy) {
        if (!outer.isPrepared()) {
            return null;
        }
        for (Object nested : vmProxy.nestedTypes(outer)) {
            ReferenceType found = AspectJDebugUtil.findNestedClass((ReferenceType)nested, aClass, position, vmProxy);
            if (found == null) continue;
            return found;
        }
        try {
            if (outer.locationsOfLine(position.getLine() + 1).size() > 0) {
                return outer;
            }
            int[] range = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
            for (Location location : outer.allLineLocations()) {
                int locationLine = location.lineNumber() - 1;
                range[0] = Math.min(range[0], locationLine);
                range[1] = Math.max(range[1], locationLine);
            }
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                if (position.getLine() < range[0]) return null;
                if (position.getLine() > range[1]) return null;
                int line = Math.min(range[0] + 1, range[1]);
                SourcePosition candidatePosition = SourcePosition.createFromLine((PsiFile)aClass.getContainingFile(), (int)line);
                ReferenceType referenceType = aClass.equals(JVMNameUtil.getClassAt((SourcePosition)candidatePosition)) ? outer : null;
                return referenceType;
            }
            finally {
                token.finish();
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    public static class ClassData {
        final PsiClass aClass;
        final boolean isTopLevel;
        final String topClassName;

        private ClassData(PsiClass aClass, boolean topLevel, String topClassName) {
            this.aClass = aClass;
            this.isTopLevel = topLevel;
            this.topClassName = topClassName;
        }
    }
}

