/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build.ui;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.lang.aspectj.util.LibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjPathPanel
extends JPanel {
    private final Module myModule;
    private final Project myProject;
    private final JBList myList;
    private final CollectionListModel<AjPathEntries.Entry> myModel;
    private final Map<AjPathEntries.Entry, Object> myMapping;

    public AjPathPanel(@NotNull Module module) {
        if (module == null) {
            AjPathPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myModule = module;
        this.myProject = module.getProject();
        this.myModel = new CollectionListModel((Object[])new AjPathEntries.Entry[0]);
        this.myMapping = ContainerUtil.newHashMap();
        this.myList = new JBList(this.myModel);
        this.myList.setCellRenderer((ListCellRenderer)((Object)new PathEntryCellRenderer()));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList);
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AjPathPanel.this.addEntry();
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AjPathPanel.this.removeEntry();
            }
        });
        this.add((Component)decorator.createPanel(), "Center");
    }

    private void addEntry() {
        List<Object> candidates = LibraryUtil.getAspectPathCandidates(this.myModule, this.myMapping.values());
        if (candidates.isEmpty()) {
            Messages.showWarningDialog((Project)this.myProject, (String)AspectJBundle.message("aspect.path.no.deps.message", new Object[0]), (String)AspectJBundle.message("aspect.path.no.items.title", new Object[0]));
        } else {
            Collections.sort(candidates, new ItemComparator());
            ChooseModuleOrLibraryDialog dialog = new ChooseModuleOrLibraryDialog(this.myProject, candidates);
            dialog.show();
            for (Object object : dialog.getChosenElements()) {
                AjPathEntries.Entry entry = null;
                if (object instanceof Library) {
                    entry = LibraryUtil.create((Library)object);
                } else if (object instanceof Module) {
                    entry = LibraryUtil.create((Module)object);
                }
                if (entry == null) continue;
                this.myModel.add((Object)entry);
                this.myMapping.put(entry, object);
            }
        }
    }

    private void removeEntry() {
        Object[] values;
        for (Object value : values = this.myList.getSelectedValues()) {
            if (!(value instanceof AjPathEntries.Entry)) continue;
            AjPathEntries.Entry entry = (AjPathEntries.Entry)value;
            this.myModel.remove((Object)entry);
            this.myMapping.remove(entry);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myList.setEnabled(enabled);
    }

    @NotNull
    public List<AjPathEntries.Entry> getEntries() {
        List list = this.myModel.getItems();
        if (list == null) {
            AjPathPanel.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setEntries(@Nullable List<AjPathEntries.Entry> entries) {
        if (entries != null && !entries.isEmpty()) {
            this.myModel.replaceAll(entries);
            this.myMapping.clear();
            this.myMapping.putAll(LibraryUtil.mapEntries(entries, this.myProject));
        } else {
            this.myModel.removeAll();
            this.myMapping.clear();
        }
    }

    private static String getItemName(Object item) {
        if (item instanceof Module) {
            return ((Module)item).getName();
        }
        if (item instanceof Library) {
            return ((Library)item).getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/build/ui/AjPathPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/build/ui/AjPathPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChooseModuleOrLibraryDialog
    extends ChooseElementsDialog<Object> {
        private final Project myProject;

        public ChooseModuleOrLibraryDialog(Project project, List<Object> candidates) {
            super(project, candidates, AspectJBundle.message("aspect.path.add.title", new Object[0]), null);
            this.myProject = project;
        }

        protected String getItemText(Object item) {
            return AjPathPanel.getItemName(item);
        }

        @Nullable
        protected Icon getItemIcon(Object item) {
            if (item instanceof Module) {
                return ModuleType.get((Module)((Module)item)).getIcon();
            }
            if (item instanceof Library) {
                SimpleColoredComponent component = new SimpleColoredComponent();
                OrderEntryAppearanceService.getInstance().forLibrary(this.myProject, (Library)item, false).customize(component);
                return component.getIcon();
            }
            return null;
        }
    }

    private static class ItemComparator
    implements Comparator<Object> {
        private ItemComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return Comparing.compare((Comparable)((Object)AjPathPanel.getItemName(o1)), (Comparable)((Object)AjPathPanel.getItemName(o2)));
        }
    }

    private class PathEntryCellRenderer
    extends ColoredListCellRendererWrapper<AjPathEntries.Entry> {
        private PathEntryCellRenderer() {
        }

        protected void doCustomize(JList list, AjPathEntries.Entry entry, int index, boolean selected, boolean hasFocus) {
            Object module;
            if (entry instanceof AjPathEntries.LibraryEntry) {
                Object library = AjPathPanel.this.myMapping.get(entry);
                if (library instanceof LibraryEx) {
                    boolean valid = ((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty();
                    OrderEntryAppearanceService.getInstance().forLibrary(AjPathPanel.this.myProject, (Library)library, !valid).customize((SimpleColoredComponent)this);
                    return;
                }
            } else if (entry instanceof AjPathEntries.ModuleEntry && (module = AjPathPanel.this.myMapping.get(entry)) instanceof Module) {
                OrderEntryAppearanceService.getInstance().forModule((Module)module).customize((SimpleColoredComponent)this);
                return;
            }
            FileAppearanceService.getInstance().forInvalidUrl(entry.getName()).customize((SimpleColoredComponent)this);
        }
    }
}

