/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.jsf.model.jam.JsfJamManagedBean;
import com.intellij.jsf.model.jam.JsfJamManagedProperty;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.managedBeans.ManagedBean;
import com.intellij.jsf.resources.FacesUIBundle;
import com.intellij.jsf.toolWindow.tree.nodes.AbstractJsfTypeNode;
import com.intellij.jsf.toolWindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfDomManagedBeanNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelNodeUtils;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfNodeTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.J2EEIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ManagedBeansNode
extends AbstractJsfTypeNode {
    public ManagedBeansNode(Module module, JsfModuleNode jsfModuleNode, boolean showFromLibraries) {
        super(jsfModuleNode, module, JsfNodeTypes.MANAGED_BEANS, showFromLibraries);
        this.setUniformIcon(J2EEIcons.ManagedBean);
    }

    protected void doUpdate() {
        this.setPlainText(FacesUIBundle.message("managed.beans.node.name", new Object[0]));
    }

    @Override
    protected void addAnnotatedNodes(Collection<JsfModelElementNode> annotatedNodes) {
        List<JsfJamManagedBean> managedBeans = JsfJamModel.getModel(this.getModule()).getManagedBeans(this.isShowFromLibraries());
        for (JsfJamManagedBean managedBean : managedBeans) {
            annotatedNodes.add(new ManagedBeanAnnotatedMembersNode(managedBean));
        }
    }

    @Override
    @NotNull
    protected Collection<SimpleNode> getFacesDomModelNodes(@NotNull FacesDomModel domModel) {
        if (domModel == null) {
            ManagedBeansNode.$$$reportNull$$$0(0);
        }
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        List<ManagedBean> domManagedBeans = domModel.getFacesConfig().getManagedBeans();
        for (ManagedBean domManagedBean : domManagedBeans) {
            nodes.add(new JsfDomManagedBeanNode(domManagedBean, this));
        }
        ArrayList<SimpleNode> arrayList = nodes;
        if (arrayList == null) {
            ManagedBeansNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/toolWindow/tree/nodes/ManagedBeansNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/toolWindow/tree/nodes/ManagedBeansNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacesDomModelNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFacesDomModelNodes";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ManagedBeanAnnotatedMembersNode
    extends AnnotatedMembersNode<PsiClass> {
        private final JsfJamManagedBean myManagedBean;

        public ManagedBeanAnnotatedMembersNode(JsfJamManagedBean managedBean) {
            super(ManagedBeansNode.this.getModule(), managedBean.getPsiElement(), ManagedBeansNode.this);
            this.myManagedBean = managedBean;
        }

        @Override
        protected String getActualNodeName() {
            return this.myManagedBean.getName();
        }

        @Override
        protected boolean isAddContaingClassInfo() {
            String name = this.myManagedBean.getName();
            return !name.equals(this.myManagedBean.getPsiElement().getName());
        }

        @Override
        public SimpleNode[] getChildren() {
            Collection<JsfModelElementNode> managedPropertiesNodes = JsfModelNodeUtils.createSortedList();
            List<JsfJamManagedProperty> properties = this.myManagedBean.getManagedProperties();
            for (final JsfJamManagedProperty managedProperty : properties) {
                managedPropertiesNodes.add(new AnnotatedMembersNode<PsiField>(ManagedBeansNode.this.getModule(), managedProperty.getPsiElement(), (SimpleNode)this){

                    @Override
                    protected String getActualNodeName() {
                        String name = managedProperty.getName();
                        String value = managedProperty.getValue();
                        return name + (StringUtil.isEmptyOrSpaces((String)value) ? "" : " = " + value);
                    }

                    @Override
                    protected String getNodeTextExt() {
                        return ((PsiField)this.getModelElement()).getType().getCanonicalText();
                    }

                    @Override
                    protected boolean isAddContaingClassInfo() {
                        return false;
                    }
                });
            }
            return managedPropertiesNodes.toArray(new JsfModelElementNode[managedPropertiesNodes.size()]);
        }
    }
}

