/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.jam.application;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jsf.references.JsfPsiAnnotationParamSimpleResourceReference;
import com.intellij.jsf.references.JsfResourceNameReferenceWithLibraryAttribute;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfResourceNameConverter
extends JamConverter<String> {
    public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<String> context) {
        String contextValue = (String)context.getValue();
        if (StringUtil.isEmptyOrSpaces((String)contextValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JsfResourceNameConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiLiteral literalExpression = context.getPsiLiteral();
        if (JsfResourceNameConverter.isAbsolutePath(contextValue)) {
            Object libraryName;
            PsiLiteralExpression libraryNameExpression = JsfPsiAnnotationParamSimpleResourceReference.getLibraryNameExpression((PsiElement)literalExpression);
            if (libraryNameExpression != null && (libraryName = libraryNameExpression.getValue()) instanceof String) {
                Set<PsiDirectory> resourceLibraryDirectories = JsfCommonUtils.getResourceLibraryDirectoriesWithVersions(ModuleUtilCore.findModuleForPsiElement((PsiElement)literalExpression), (String)libraryName);
                PsiReference[] psiReferenceArray = JsfCommonUtils.createResourceIdentifierReferences(contextValue, (PsiElement)literalExpression, resourceLibraryDirectories);
                if (psiReferenceArray == null) {
                    JsfResourceNameConverter.$$$reportNull$$$0(1);
                }
                return psiReferenceArray;
            }
            PsiReference[] psiReferenceArray = JsfCommonUtils.createTopLevelResourceIdentifierReferences(contextValue, (PsiElement)literalExpression);
            if (psiReferenceArray == null) {
                JsfResourceNameConverter.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{JsfResourceNameConverter.createResourceReferenceWithSeparatedLibrary(literalExpression)};
        if (psiReferenceArray == null) {
            JsfResourceNameConverter.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static boolean isAbsolutePath(String contextValue) {
        return contextValue.contains("/");
    }

    private static JsfResourceNameReferenceWithLibraryAttribute<PsiLiteral> createResourceReferenceWithSeparatedLibrary(PsiLiteral literalExpression) {
        return new JsfPsiAnnotationParamSimpleResourceReference(literalExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/jam/application/JsfResourceNameConverter", "createReferences"));
    }
}

