/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.generation;

import com.intellij.openapi.util.Ref;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class PkConverter {
    @NonNls
    private static final String SEPARATOR = "\"&\"";
    private static final String ACCESS_STRING_NAME = "${accesString}";
    private static final String BYTE = "java.lang.Byte";
    private static final String SHORT = "java.lang.Short";
    private static final String INTEGER = "java.lang.Integer";
    private static final String LONG = "java.lang.Long";
    private static final String BIGINT = "java.math.BigInteger";
    private static final String FLOAT = "java.lang.Float";
    private static final String DOUBLE = "java.lang.Double";
    @NonNls
    private static final Map<String, String> myConverterTypes = new THashMap();

    public static String generateGetPKString(PersistentEntity entity, PersistenceModelBrowser browser, String paramName, String outputParam) {
        PersistentEmbeddedAttribute id;
        Ref idClassRef = new Ref();
        ArrayList<PersistentEmbeddedAttribute> embeddedIds = new ArrayList<PersistentEmbeddedAttribute>();
        ArrayList<PersistentAttribute> ids = new ArrayList<PersistentAttribute>();
        PkConverter.collectIdInformation(entity, browser, (Ref<PsiClass>)idClassRef, ids, embeddedIds);
        StringBuilder sb = new StringBuilder();
        if (!idClassRef.isNull()) {
            PsiClass idClass = (PsiClass)idClassRef.get();
            boolean first = true;
            for (PersistentAttribute id2 : ids) {
                if (!first) {
                    sb.append("+").append(SEPARATOR).append("+");
                } else {
                    first = false;
                }
                String attrAccess = PkConverter.getReadAccessString(id2);
                sb.append(PkConverter.getToString(id2, paramName + "." + attrAccess));
            }
        } else if (!embeddedIds.isEmpty()) {
            id = embeddedIds.get(0);
            PersistentObject embeddable = (PersistentObject)browser.queryTargetPersistentObjects(id).findFirst();
            String accessString = PkConverter.getReadAccessString((PersistentAttribute)id);
            if (embeddable == null) {
                sb.append(PkConverter.getToString((PersistentAttribute)id, paramName + "." + accessString));
            } else {
                boolean first = true;
                for (PersistentAttribute idAttr : browser.queryAttributes(embeddable)) {
                    if (!first) {
                        sb.append("+").append(SEPARATOR).append("+");
                    } else {
                        first = false;
                    }
                    String attrAccess = PkConverter.getReadAccessString(idAttr);
                    sb.append(PkConverter.getToString(idAttr, paramName + "." + accessString + "." + attrAccess));
                }
            }
        } else if (!ids.isEmpty()) {
            id = ids.get(0);
            String attrAccess = PkConverter.getReadAccessString((PersistentAttribute)id);
            sb.append(PkConverter.getToString((PersistentAttribute)id, paramName + "." + attrAccess));
        }
        boolean empty = sb.length() == 0;
        sb.insert(0, "final String " + outputParam + "=");
        sb.append(empty ? "\"\";" : ";");
        return sb.toString();
    }

    public static String generateGetPKObject(PersistentEntity entity, PersistenceModelBrowser browser, String paramName, String outputParam) {
        Ref idClassRef = new Ref();
        ArrayList<PersistentEmbeddedAttribute> embeddedIds = new ArrayList<PersistentEmbeddedAttribute>();
        ArrayList<PersistentAttribute> ids = new ArrayList<PersistentAttribute>();
        PkConverter.collectIdInformation(entity, browser, (Ref<PsiClass>)idClassRef, ids, embeddedIds);
        StringBuilder sb = new StringBuilder();
        if (!idClassRef.isNull()) {
            PsiClass idClass = (PsiClass)idClassRef.get();
            String qName = idClass.getQualifiedName();
            PkConverter.generateSetters(sb, paramName, outputParam, qName, ids);
        } else if (!embeddedIds.isEmpty()) {
            PersistentEmbeddedAttribute id = embeddedIds.get(0);
            PersistentObject embeddable = (PersistentObject)browser.queryTargetPersistentObjects(id).findFirst();
            PsiClass psiClass = (PsiClass)id.getTargetEmbeddableClass().getValue();
            String qName = psiClass != null ? psiClass.getQualifiedName() : id.getTargetEmbeddableClass().getStringValue();
            PkConverter.generateSetters(sb, paramName, outputParam, qName, browser.queryAttributes(embeddable).findAll());
        } else if (!ids.isEmpty()) {
            PersistentAttribute id = ids.get(0);
            PsiType type = id.getPsiType();
            String qName = type == null ? "XXX" : type.getCanonicalText();
            sb.append("final ").append(qName == null ? "XXX" : qName).append(" ").append(outputParam).append("=").append(PkConverter.getFromString(id, paramName)).append(";");
        }
        return sb.toString();
    }

    private static void generateSetters(StringBuilder sb, String paramName, String outputParam, String qName, Collection<? extends PersistentAttribute> ids) {
        sb.append("final ").append(qName == null ? "XXX" : qName).append(" ").append(outputParam).append("=new ").append(qName == null ? "XXX" : qName).append("();\n");
        if (ids.size() > 1) {
            sb.append("final java.util.StringTokenizer _st = new java.util.StringTokenizer(" + paramName + ", " + SEPARATOR + ");\n");
            sb.append("if (_st.countTokens() != " + ids.size() + ") {\n");
            boolean first = true;
            for (PersistentAttribute persistentAttribute : ids) {
                if (!first) {
                    sb.append("\n");
                } else {
                    first = false;
                }
                sb.append(outputParam).append(".").append(PkConverter.getWriteAccessString(persistentAttribute, PkConverter.getFromString(persistentAttribute, "_st.nextToken()"))).append(";");
            }
            sb.append("\n}");
        } else if (ids.size() != 0) {
            PersistentAttribute id = ids.iterator().next();
            sb.append(outputParam).append(".").append(PkConverter.getWriteAccessString(id, PkConverter.getFromString(id, paramName))).append(";");
        }
    }

    private static String getToString(PersistentAttribute attributeBase, String accessString) {
        return "String.valueOf(" + accessString + ")";
    }

    private static String getReadAccessString(PersistentAttribute id) {
        String name = (String)id.getName().getValue();
        PsiMember member = id.getPsiMember();
        return member == null ? name : (member instanceof PsiField ? member.getName() : member.getName() + "()");
    }

    private static String getWriteAccessString(PersistentAttribute id, String value) {
        String name = (String)id.getName().getValue();
        PsiMember member = id.getPsiMember();
        return member == null ? name + "=" + value : (member instanceof PsiField ? member.getName() + "=" + value : PropertyUtilBase.suggestSetterName((String)name) + "(" + value + ")");
    }

    private static String getFromString(PersistentAttribute attributeBase, String accessString) {
        PsiType type = attributeBase.getPsiType();
        if (type == null) {
            return "";
        }
        String qName = type.getCanonicalText();
        if ("java.lang.String".equals(qName)) {
            return accessString;
        }
        if (myConverterTypes.containsKey(qName)) {
            return myConverterTypes.get(qName).replace(ACCESS_STRING_NAME, accessString);
        }
        return "String.valueOf(" + accessString + ")";
    }

    private static void collectIdInformation(PersistentEntity entity, PersistenceModelBrowser browser, Ref<PsiClass> idClassRef, ArrayList<PersistentAttribute> ids, ArrayList<PersistentEmbeddedAttribute> embeddedIds) {
        browser.queryPersistentObjectHierarchy((PersistentObject)entity).forEach(persistentObject -> {
            if (persistentObject instanceof PersistentEntityBase) {
                PersistentEntityBase entityBase = (PersistentEntityBase)persistentObject;
                PsiClass idClass = (PsiClass)entityBase.getIdClassValue().getValue();
                if (idClass != null && idClassRef.isNull()) {
                    idClassRef.set((Object)idClass);
                }
                for (PersistentAttribute base : browser.queryAttributes((PersistentObject)entityBase)) {
                    if (!base.getAttributeModelHelper().isIdAttribute()) continue;
                    if (base instanceof PersistentEmbeddedAttribute) {
                        embeddedIds.add((PersistentEmbeddedAttribute)base);
                        continue;
                    }
                    ids.add(base);
                }
            }
            return true;
        });
    }

    static {
        myConverterTypes.put(BYTE, "new Byte(${accesString})");
        myConverterTypes.put(SHORT, "new Short(${accesString})");
        myConverterTypes.put(INTEGER, "new Integer(${accesString})");
        myConverterTypes.put(LONG, "new Long(${accesString})");
        myConverterTypes.put(BIGINT, "new BigInteger(${accesString})");
        myConverterTypes.put(FLOAT, "new Float(${accesString})");
        myConverterTypes.put(DOUBLE, "new Double(${accesString})");
        myConverterTypes.put("byte", "Byte.parseByte(${accesString})");
        myConverterTypes.put("short", "Short.parseShort(${accesString})");
        myConverterTypes.put("int", "Integer.parseInt(${accesString})");
        myConverterTypes.put("long", "Long.parseLong(${accesString})");
        myConverterTypes.put("float", "Float.parseFloat(${accesString})");
        myConverterTypes.put("double", "Double.parseDouble(${accesString})");
    }
}

