/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.jsf.composite.CompositeComponentDescriptor;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeNamespaceDescriptor
extends XmlNSDescriptorImpl {
    private final String myNamespace;
    private final String myResourcesPath;
    private static final Key<CachedValue<Map<String, Set<XmlFile>>>> COMPOSITE_NAMESPACE_FILES_CACHE = Key.create((String)"COMPOSITE_NAMESPACE_FILES_CACHE");

    public CompositeNamespaceDescriptor(@NotNull String namespace, @NotNull String resourcePath) {
        if (namespace == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(0);
        }
        if (resourcePath == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(1);
        }
        this.myNamespace = namespace;
        this.myResourcesPath = resourcePath;
    }

    public String getResourcesPath() {
        return this.myResourcesPath;
    }

    public void init(PsiElement element) {
        super.init(element);
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(2);
        }
        if (!this.myNamespace.equals(tag.getNamespace())) {
            return null;
        }
        return this.getCompositeComponentDescriptor(tag);
    }

    @Nullable
    private XmlElementDescriptor getCompositeComponentDescriptor(@NotNull XmlTag tag) {
        Module module;
        if (tag == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag)) == null) {
            return null;
        }
        for (XmlFile file : CompositeNamespaceDescriptor.getCompositeComponentsFiles(module, this.myResourcesPath)) {
            if (!tag.getLocalName().equals(FileUtil.getNameWithoutExtension((String)file.getName()))) continue;
            return new CompositeComponentDescriptor(file, tag.getNamespacePrefix());
        }
        return null;
    }

    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        return super.getElementDescriptor(localName, namespace);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        if (doc == null) {
            if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                CompositeNamespaceDescriptor.$$$reportNull$$$0(4);
            }
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)doc);
        XmlTag rootTag = doc.getRootTag();
        if (rootTag != null) {
            String prefix = rootTag.getPrefixByNamespace(this.myNamespace);
            if (module != null && prefix != null) {
                HashSet<CompositeComponentDescriptor> descriptors = new HashSet<CompositeComponentDescriptor>();
                for (XmlFile file : CompositeNamespaceDescriptor.getCompositeComponentsFiles(module, this.myResourcesPath)) {
                    descriptors.add(new CompositeComponentDescriptor(file, prefix));
                }
                XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
                if (xmlElementDescriptorArray == null) {
                    CompositeNamespaceDescriptor.$$$reportNull$$$0(5);
                }
                return xmlElementDescriptorArray;
            }
        }
        if (XmlElementDescriptor.EMPTY_ARRAY == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(6);
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public static Set<XmlFile> getCompositeComponentsFiles(@NotNull Module module, @NotNull String resourcesPath) {
        Map cached;
        Set<XmlFile> files;
        if (module == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(7);
        }
        if (resourcesPath == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(8);
        }
        Set<XmlFile> set = (files = (Set<XmlFile>)(cached = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                CompositeNamespaceDescriptor.$$$reportNull$$$0(13);
            }
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> {
                if (module == null) {
                    CompositeNamespaceDescriptor.$$$reportNull$$$0(14);
                }
                return CompositeNamespaceDescriptor.collectCompositeComponentsFiles(module, key);
            });
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        })).get(resourcesPath)) != null ? files : Collections.emptySet();
        if (set == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    private static Set<XmlFile> collectCompositeComponentsFiles(@NotNull Module module, @NotNull String resourcesPath) {
        if (module == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(10);
        }
        if (resourcesPath == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(11);
        }
        HashSet<XmlFile> files = new HashSet<XmlFile>();
        for (PsiDirectory directory : JsfCommonUtils.collectDirectories(module, resourcesPath)) {
            for (PsiFile file : directory.getFiles()) {
                if (!(file instanceof XmlFile) || !CompositeUtil.hasCompositeNsDefinedIn((XmlFile)file)) continue;
                files.add((XmlFile)file);
            }
        }
        HashSet<XmlFile> hashSet = files;
        if (hashSet == null) {
            CompositeNamespaceDescriptor.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/composite/CompositeNamespaceDescriptor";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcesPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/composite/CompositeNamespaceDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeComponentsFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCompositeComponentsFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeComponentDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeComponentsFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectCompositeComponentsFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompositeComponentsFiles$1";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

