/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.actions;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.generation.FacesGenerationUtil;
import com.intellij.jsf.generation.ui.FacesGenerateDialog;
import com.intellij.jsf.generation.ui.FacesGenerationPanel;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class GenerateFacesPagesAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        PersistencePackage unit = GenerateFacesPagesAction.getPersistenceUnit(e.getDataContext());
        PersistenceFacet facet = GenerateFacesPagesAction.getPersistenceFacet(e.getDataContext());
        assert (facet != null);
        Collection webFacets = WebFacet.getInstances((Module)facet.getModule());
        if (webFacets.size() > 0) {
            WebFacet webFacet = (WebFacet)webFacets.iterator().next();
            FacesGenerateDialog dialog = new FacesGenerateDialog(webFacet, facet, unit);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                FacesGenerationPanel panel = dialog.getFacesGenerationPanel();
                FacesGenerationUtil.generateFacesPages(panel.getGenerateSettings(), panel.getEntityInfos());
            }
        }
    }

    public void update(AnActionEvent event) {
        PersistencePackage persistenceUnit = GenerateFacesPagesAction.getPersistenceUnit(event.getDataContext());
        PersistenceFacet facet = GenerateFacesPagesAction.getPersistenceFacet(event.getDataContext());
        event.getPresentation().setVisible(facet != null && persistenceUnit != null && JsfCommonUtils.isJsfSupported(facet.getModule()));
    }

    @Nullable
    private static PersistencePackage getPersistenceUnit(DataContext dataContext) {
        return (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
    }

    @Nullable
    private static PersistenceFacet getPersistenceFacet(DataContext dataContext) {
        return (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
    }
}

