/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructMember {
    protected int accessFlags;
    protected Map<String, StructGeneralAttribute> attributes;

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public StructGeneralAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public boolean hasModifier(int modifier) {
        return (this.accessFlags & modifier) == modifier;
    }

    public boolean isSynthetic() {
        return this.hasModifier(4096) || this.hasAttribute("Synthetic");
    }

    protected Map<String, StructGeneralAttribute> readAttributes(DataInputFullStream in, ConstantPool pool) throws IOException {
        int length = in.readUnsignedShort();
        HashMap<String, StructGeneralAttribute> attributes = new HashMap<String, StructGeneralAttribute>(length);
        for (int i = 0; i < length; ++i) {
            StructGeneralAttribute table;
            int nameIndex = in.readUnsignedShort();
            String name = pool.getPrimitiveConstant(nameIndex).getString();
            StructGeneralAttribute attribute = this.readAttribute(in, pool, name);
            if (attribute == null) continue;
            if ("LocalVariableTable".equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTableAttribute)attributes.get(name);
                ((StructLocalVariableTableAttribute)table).add((StructLocalVariableTableAttribute)attribute);
                continue;
            }
            if ("LocalVariableTypeTable".equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTypeTableAttribute)attributes.get(name);
                ((StructLocalVariableTypeTableAttribute)table).add((StructLocalVariableTypeTableAttribute)attribute);
                continue;
            }
            attributes.put(attribute.getName(), attribute);
        }
        return attributes;
    }

    protected StructGeneralAttribute readAttribute(DataInputFullStream in, ConstantPool pool, String name) throws IOException {
        StructGeneralAttribute attribute = StructGeneralAttribute.createAttribute(name);
        int length = in.readInt();
        if (attribute == null) {
            in.discard(length);
        } else {
            attribute.initContent(in, pool);
        }
        return attribute;
    }
}

