/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class AndroidBuildTargetType<T extends AndroidBuildTarget>
extends BuildTargetType<T> {
    private final String myPresentableName;

    AndroidBuildTargetType(@NotNull String typeId, @NotNull String presentableName) {
        if (typeId == null) {
            AndroidBuildTargetType.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            AndroidBuildTargetType.$$$reportNull$$$0(1);
        }
        super(typeId);
        this.myPresentableName = presentableName;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            AndroidBuildTargetType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<T> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            AndroidBuildTargetType.$$$reportNull$$$0(3);
        }
        if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidBuildTargetType.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<T> targets = new ArrayList<T>();
        for (JpsModule module : model.getProject().getModules()) {
            T target;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null || (target = this.createBuildTarget(extension)) == null) continue;
            targets.add(target);
        }
        ArrayList<T> arrayList = targets;
        if (arrayList == null) {
            AndroidBuildTargetType.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public abstract T createBuildTarget(@NotNull JpsAndroidModuleExtension var1);

    @NotNull
    public BuildTargetLoader<T> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            AndroidBuildTargetType.$$$reportNull$$$0(6);
        }
        final HashMap<String, AndroidBuildTarget> targetMap = new HashMap<String, AndroidBuildTarget>();
        for (AndroidBuildTarget target : this.computeAllTargets(model)) {
            targetMap.put(target.getId(), target);
        }
        BuildTargetLoader buildTargetLoader = new BuildTargetLoader<T>(){

            @Nullable
            public T createTarget(@NotNull String targetId) {
                if (targetId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (Object)((AndroidBuildTarget)((Object)targetMap.get(targetId)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/android/builder/AndroidBuildTargetType$1", "createTarget"));
            }
        };
        if (buildTargetLoader == null) {
            AndroidBuildTargetType.$$$reportNull$$$0(7);
        }
        return buildTargetLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidBuildTargetType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidBuildTargetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllTargets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeAllTargets";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

