/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.el.SpringElTemplateParser;
import com.intellij.spring.el.contextProviders.SpringElContextProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringElInjector
implements MultiHostInjector {
    private static final Set<String> ANNOTATIONS = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.beans.factory.annotation.Value", "org.springframework.scheduling.annotation.Scheduled"});

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        PsiElement parent;
        if (registrar == null) {
            SpringElInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            SpringElInjector.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)host.getProject())) {
            return;
        }
        if (host instanceof XmlAttributeValue) {
            PsiFile file = host.getContainingFile();
            if (!JamCommonUtil.isPlainXmlFile((PsiElement)file)) {
                return;
            }
            if (SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
                SpringElInjector.doRegister(registrar, host);
            }
        } else if (host instanceof PsiLiteralExpression && (parent = host.getParent().getParent()) instanceof PsiAnnotationParameterList && !parent.getProject().isDefault() && SpringElInjector.isSpringElCompatibleAnnotation((PsiAnnotation)parent.getParent())) {
            SpringElInjector.doRegister(registrar, host);
        }
    }

    private static boolean isSpringElCompatibleAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SpringElInjector.$$$reportNull$$$0(2);
        }
        return ANNOTATIONS.contains(psiAnnotation.getQualifiedName());
    }

    private static void doRegister(MultiHostRegistrar registrar, PsiElement host) {
        String text = host.getText();
        List<TextRange> ranges = SpringElTemplateParser.parse(text);
        if (!ranges.isEmpty()) {
            for (TextRange textRange : ranges) {
                registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, textRange).doneInjecting();
            }
            host.putUserData(ELContextProvider.ourContextProviderKey, (Object)new SpringElContextProvider(host));
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class, PsiLiteralExpression.class);
        if (list == null) {
            SpringElInjector.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/el/SpringElInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/el/SpringElInjector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSpringElCompatibleAnnotation";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

