/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.debug;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import icons.VaadinIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaadinDevModeServer
extends GwtDevModeServer {
    private static final Logger LOG = Logger.getInstance(VaadinDevModeServer.class);

    public VaadinDevModeServer() {
        super("vaadin-jetty-launcher", "Vaadin Jetty Launcher");
    }

    @Nullable
    public Icon getIcon() {
        return VaadinIcons.Vaadin_icon;
    }

    public void patchParameters(@NotNull JavaParameters parameters, String originalOutputDir, @NotNull GwtFacet gwtFacet) {
        if (parameters == null) {
            VaadinDevModeServer.$$$reportNull$$$0(0);
        }
        if (gwtFacet == null) {
            VaadinDevModeServer.$$$reportNull$$$0(1);
        }
        ParametersList params = parameters.getProgramParametersList();
        params.add("-server");
        params.add("com.intellij.vaadin.rt.VaadinDevModeJettyLauncher:" + originalOutputDir);
        File vaadinClassesRoot = new File(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
        File vaadinLibDir = vaadinClassesRoot.isDirectory() ? new File(PathManager.getHomePath(), "plugins/vaadin/rt/lib") : new File(vaadinClassesRoot.getParentFile(), "rt");
        File vaadinJettyLauncherJar = new File(vaadinLibDir, "vaadin-jetty-launcher.jar");
        LOG.assertTrue(vaadinJettyLauncherJar.exists(), (Object)(vaadinJettyLauncherJar + " doesn't exist"));
        parameters.getClassPath().add(vaadinJettyLauncherJar);
    }

    @NotNull
    public String patchWarDirectoryPath(@NotNull String warDirectoryPath) {
        if (warDirectoryPath == null) {
            VaadinDevModeServer.$$$reportNull$$$0(2);
        }
        String string = new File(warDirectoryPath, "VAADIN/widgetsets").getAbsolutePath();
        if (string == null) {
            VaadinDevModeServer.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warDirectoryPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vaadin/debug/VaadinDevModeServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vaadin/debug/VaadinDevModeServer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "patchWarDirectoryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "patchParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "patchWarDirectoryPath";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

