/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.vaadin.framework.VaadinVersionUtil;
import icons.VaadinIcons;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class VaadinCreateElementActionBase
extends CreateElementActionBase {
    protected VaadinCreateElementActionBase(String text, String description) {
        super(text, description, VaadinIcons.Vaadin_icon);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return false;
        }
        if (!VaadinVersionUtil.hasVaadinFramework(module)) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        for (PsiDirectory directory : view.getDirectories()) {
            if (!index.isUnderSourceRootOfType(directory.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES)) continue;
            return true;
        }
        return false;
    }
}

