/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModel;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModelData;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModelDelegate;
import com.intellij.javaee.oss.transport.MultiTargetRemoteStagingProvider;
import com.intellij.javaee.oss.transport.RemoteStagingTargetDefinition;
import com.intellij.javaee.oss.transport.TransportTargetKind;
import com.intellij.javaee.oss.transport.TransportTargetModelBase;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.Collections;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;
import org.jetbrains.idea.tomcat.TomcatRemoteRunConfigurationEditor;
import org.jetbrains.idea.tomcat.TomcatUtil;
import org.jetbrains.idea.tomcat.admin.TomEEAgentAdminServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminRemoteServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminServerBase;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public class TomcatRemoteModel
extends TomcatServerModel
implements MultiTargetRemoteServerModel {
    @NonNls
    private static final String DATA_ELEMENT = "data";
    private int myJndiPort = 1099;
    @NonNls
    public static final String CONTEXT_TARGET_NAME = "CONTEXT_XML";
    @NonNls
    public static final String STAGING_TARGET_NAME = "STAGING";
    public static final RemoteStagingTargetDefinition CONTEXT_TARGET_DEFINITION = new RemoteStagingTargetDefinition("CONTEXT_XML", TomcatBundle.message("TomcatRemoteModel.target.definition.context", new Object[0]), TransportTargetKind.WATCHED);
    public static final RemoteStagingTargetDefinition STAGING_TARGET_DEFINITION = new RemoteStagingTargetDefinition("STAGING", TomcatBundle.message("TomcatRemoteModel.target.definition.staging", new Object[0]), TransportTargetKind.STAGING);
    public static final MultiTargetRemoteStagingProvider STAGING_PROVIDER = new MultiTargetRemoteStagingProvider(new RemoteStagingTargetDefinition[]{CONTEXT_TARGET_DEFINITION, STAGING_TARGET_DEFINITION});
    private MultiTargetRemoteServerModelDelegate myTransportDelegate = STAGING_PROVIDER.initModelDelegate(new MultiTargetRemoteServerModelDelegate(), (MultiTargetRemoteServerModel)this);

    @Override
    protected TomcatAdminServerBase<?> createTomcatServerAdmin(JavaeeServerInstance processHandler, TomEEAgentAdminServerImpl tomEEAdmin) {
        return new TomcatAdminRemoteServerImpl(this, tomEEAdmin);
    }

    @Override
    public int getJndiPort() {
        return this.myJndiPort;
    }

    public void setJndiPort(int jndiPort) {
        this.myJndiPort = jndiPort;
    }

    public String getTransportHostId() {
        return this.myTransportDelegate.getTransportHostId();
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportDelegate.setTransportHostId(transportHostId);
    }

    public TransportTargetModelBase getTarget(String targetName) {
        return this.myTransportDelegate.getTarget(targetName);
    }

    public boolean transferContextFile(File contextXmlFile) {
        return this.myTransportDelegate.transferFile(CONTEXT_TARGET_NAME, contextXmlFile);
    }

    public boolean isDeployAllowed() {
        return this.myTransportDelegate.isDeployAllowed();
    }

    public String prepareDeployment(String sourcePath) throws RuntimeConfigurationException {
        return this.myTransportDelegate.prepareDeployment(STAGING_TARGET_NAME, sourcePath, false);
    }

    @Override
    public boolean isUseJmx() {
        return super.isUseJmx() && this.hasDeployments();
    }

    public boolean hasDeployments() {
        return !this.getCommonModel().getDeploymentModels().isEmpty();
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.isVersion5OrHigher()) {
            super.checkConfiguration();
            if (this.hasDeployments() && this.myJndiPort <= 0) {
                throw new RuntimeConfigurationError(TomcatBundle.message("error.jmx.port.not.specified", new Object[0]));
            }
            this.myTransportDelegate.checkConfiguration(Collections.singleton(STAGING_TARGET_NAME));
        } else if (this.hasDeployments()) {
            throw new RuntimeConfigurationError(TomcatBundle.message("error.remote.deploy.not.supported.for.under.v5", new Object[0]));
        }
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new TomcatRemoteRunConfigurationEditor();
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element dataElement = element.getChild(DATA_ELEMENT);
        if (dataElement == null) {
            return;
        }
        TomcatRemoteModelData settings = (TomcatRemoteModelData)((Object)XmlSerializer.deserialize((Element)dataElement, TomcatRemoteModelData.class));
        this.myTransportDelegate.readFromData((MultiTargetRemoteServerModelData)settings);
        this.myJndiPort = settings.getJndiPort();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TomcatRemoteModelData settings = new TomcatRemoteModelData();
        this.myTransportDelegate.writeToData((MultiTargetRemoteServerModelData)settings);
        settings.setJndiPort(this.myJndiPort);
        Element dataElement = XmlSerializer.serialize((Object)((Object)settings), (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    public Object clone() throws CloneNotSupportedException {
        TomcatRemoteModel result = (TomcatRemoteModel)((Object)super.clone());
        result.myTransportDelegate = STAGING_PROVIDER.initModelDelegate((MultiTargetRemoteServerModelDelegate)this.myTransportDelegate.clone(), (MultiTargetRemoteServerModel)result);
        return result;
    }

    public boolean isContextDescriptorExist() {
        return this.getCommonModel().getDeploymentModels().stream().anyMatch(m -> TomcatUtil.findContextInContextXml((TomcatDeploymentModelBase)((Object)m)) != null);
    }

    @Tag(value="data")
    public static class TomcatRemoteModelData
    extends MultiTargetRemoteServerModelData {
        @Tag(value="jndi-port")
        private int myJndiPort = 1099;

        public int getJndiPort() {
            return this.myJndiPort;
        }

        public void setJndiPort(int jndiPort) {
            this.myJndiPort = jndiPort;
        }
    }
}

