/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.directoryManager.BaseDirectoryAware;
import com.intellij.javaee.directoryManager.SystemBaseDirectoryManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.jmxremote.JmxRemotePrepareResult;
import com.intellij.javaee.jmxremote.JmxRemoteUtil;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.net.NetUtils;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.Tomcat40PositionManager;
import org.jetbrains.idea.tomcat.Tomcat4Deployer;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatContextItem;
import org.jetbrains.idea.tomcat.TomcatContexts;
import org.jetbrains.idea.tomcat.TomcatLocalRunConfigurationEditor;
import org.jetbrains.idea.tomcat.TomcatModuleDeploymentModel;
import org.jetbrains.idea.tomcat.TomcatPersistentDataWrapper;
import org.jetbrains.idea.tomcat.TomcatServerXmlWrapper;
import org.jetbrains.idea.tomcat.TomcatSystemBaseDirManager;
import org.jetbrains.idea.tomcat.TomcatUtil;
import org.jetbrains.idea.tomcat.admin.TomEEAgentAdminServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminLocalServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminServerBase;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public class TomcatLocalModel
extends TomcatServerModel
implements BaseDirectoryAware {
    private static final Logger LOG = Logger.getInstance(TomcatLocalModel.class);
    @NonNls
    private static final String TOMCAT_LOCALHOST_ACCESS_LOG_ID = "Tomcat Localhost Access";
    @NonNls
    private static final String TOMCAT_CATALINA_LOG_ID = "Tomcat Catalina";
    @NonNls
    private static final String TOMCAT_MANAGER_LOG_ID = "Tomcat Manager";
    @NonNls
    private static final String TOMCAT_HOST_MANAGER_LOG_ID = "Tomcat Host Manager";
    public static final int UNDEFINED_PORT = 0;
    @NonNls
    private static final String AUTO_DEPLOY_ATTR = "autoDeploy";
    @NonNls
    private static final String UNPACK_WARS_ATTR = "unpackWARs";
    @NonNls
    private static final String TOMCAT_USERS_XML = "tomcat-users.xml";
    @NonNls
    private static final String MANAGER_CONTEXT_PATH = "/manager";
    @NonNls
    private static final String DEPLOY_ON_STARTUP_ATTR = "deployOnStartup";
    private static Pattern SESSIONS_FILENAME_PATTERN = Pattern.compile("SESSIONS\\.ser");
    public boolean DEPLOY_TOMCAT_APPS;
    public String BASE_DIRECTORY_NAME;
    public int HTTP_PORT;
    public int HTTPS_PORT;
    public int AJP_PORT;
    public int JNDI_PORT = 1099;
    public boolean PRESERVE_SESSIONS;
    private File myAccessFile;
    private File myPasswordFile;

    public TomcatLocalModel() {
        this.loadData(new TomcatModelData());
    }

    @Override
    protected TomcatAdminServerBase<?> createTomcatServerAdmin(JavaeeServerInstance serverInstance, TomEEAgentAdminServerImpl tomEEAdmin) throws Exception {
        JmxRemotePrepareResult prepareResult;
        this.prepareServer();
        this.addContexts();
        this.myAccessFile = null;
        this.myPasswordFile = null;
        String jmxUsername = null;
        String jmxPassword = null;
        if (this.isUseJmx() && (prepareResult = JmxRemoteUtil.prepare((BaseDirectoryAware)this)) != null) {
            jmxUsername = prepareResult.getUsername();
            jmxPassword = prepareResult.getPassword();
            this.myAccessFile = prepareResult.getAccessFile();
            this.myPasswordFile = prepareResult.getPasswordFile();
        }
        return new TomcatAdminLocalServerImpl(this, tomEEAdmin, serverInstance, jmxUsername, jmxPassword);
    }

    private TomcatPersistentDataWrapper createPersistentDataWrapper() throws RuntimeConfigurationError {
        ApplicationServer applicationServer = this.getApplicationServer();
        if (applicationServer == null) {
            throw new RuntimeConfigurationError(TomcatBundle.message("exception.text.application.server.not.specified", new Object[0]));
        }
        return new TomcatPersistentDataWrapper(applicationServer);
    }

    public String getHomeDirectory() throws RuntimeConfigurationException {
        return this.createPersistentDataWrapper().getHomeDirectory();
    }

    public String getSourceBaseDirectoryPath() throws RuntimeConfigurationException {
        return this.createPersistentDataWrapper().getSourceBaseDirectoryPath();
    }

    public String getBaseDirectoryPath() {
        try {
            return this.getBaseDirectory().getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    @NotNull
    public SystemBaseDirectoryManager getSystemBaseDirectoryManager() {
        SystemBaseDirectoryManager systemBaseDirectoryManager = TomcatSystemBaseDirManager.getInstance();
        if (systemBaseDirectoryManager == null) {
            TomcatLocalModel.$$$reportNull$$$0(0);
        }
        return systemBaseDirectoryManager;
    }

    @Nullable
    public String getBaseDirectoryName() {
        return this.BASE_DIRECTORY_NAME;
    }

    public void setBaseDirectoryName(@Nullable String baseDirectoryName) {
        this.BASE_DIRECTORY_NAME = baseDirectoryName;
    }

    @NotNull
    public PredefinedLogFile[] getPredefinedLogFiles() {
        ArrayList<PredefinedLogFile> result = new ArrayList<PredefinedLogFile>();
        for (PredefinedLogFile nextLogFile : super.getPredefinedLogFiles()) {
            if ("TOMCAT_LOCALHOST_LOG_ID".equals(nextLogFile.getId())) continue;
            result.add(nextLogFile);
        }
        PredefinedLogFile[] predefinedLogFileArray = result.toArray(new PredefinedLogFile[result.size()]);
        if (predefinedLogFileArray == null) {
            TomcatLocalModel.$$$reportNull$$$0(1);
        }
        return predefinedLogFileArray;
    }

    @Override
    protected List<JavaeeServerModel.LogFileFactory> getLogFileFactories() {
        ArrayList<JavaeeServerModel.LogFileFactory> result = new ArrayList<JavaeeServerModel.LogFileFactory>(super.getLogFileFactories());
        result.add(new TomcatLogFileFactory(true){

            protected String getId() {
                return TomcatLocalModel.TOMCAT_CATALINA_LOG_ID;
            }

            @Override
            protected String getFilename() {
                return "catalina";
            }
        });
        result.add(new TomcatLogFileFactory(){

            protected String getId() {
                return TomcatLocalModel.TOMCAT_MANAGER_LOG_ID;
            }

            @Override
            protected String getFilename() {
                return "manager";
            }
        });
        result.add(new TomcatLogFileFactory(){

            protected String getId() {
                return TomcatLocalModel.TOMCAT_HOST_MANAGER_LOG_ID;
            }

            @Override
            protected String getFilename() {
                return "host-manager";
            }
        });
        result.add(new TomcatLogFileFactory(){

            protected String getId() {
                return TomcatLocalModel.TOMCAT_LOCALHOST_ACCESS_LOG_ID;
            }

            @Override
            protected String getFilename() {
                return "localhost_access_log";
            }
        });
        return result;
    }

    public List<Pair<String, String>> getExternalizationMacros() {
        String tomcatHome;
        ApplicationServer server;
        SmartList list = new SmartList();
        if (!StringUtil.isEmpty((String)this.BASE_DIRECTORY_NAME)) {
            File directory = TomcatSystemBaseDirManager.getInstance().getDirectory(this.BASE_DIRECTORY_NAME);
            list.add(Pair.create((Object)"CATALINA_BASE", (Object)FileUtil.toSystemIndependentName((String)directory.getAbsolutePath())));
        }
        if ((server = this.getApplicationServer()) != null && !StringUtil.isEmpty((String)(tomcatHome = this.getHome()))) {
            list.add(Pair.create((Object)"TOMCAT_HOME", (Object)FileUtil.toSystemIndependentName((String)tomcatHome)));
        }
        return list;
    }

    public void onNewConfigurationCreated() {
        this.BASE_DIRECTORY_NAME = "";
    }

    public void onConfigurationCopied() {
        this.BASE_DIRECTORY_NAME = "";
    }

    private void loadData(TomcatModelData data) {
        this.DEPLOY_TOMCAT_APPS = data.isDeployTomcatApps();
        this.BASE_DIRECTORY_NAME = data.getBaseDirectoryName();
        this.HTTP_PORT = data.getHttpPort();
        this.HTTPS_PORT = data.getHttpsPort();
        this.JNDI_PORT = data.getJndiPort();
        this.AJP_PORT = data.getAjpPort();
        this.PRESERVE_SESSIONS = data.isPreserveSessions();
    }

    public void readExternal(Element element) throws InvalidDataException {
        boolean clearBaseDirectory = this.BASE_DIRECTORY_NAME == null;
        TomcatModelData data = new TomcatModelData();
        XmlSerializer.deserializeInto((Object)data, (Element)element);
        this.loadData(data);
        if (clearBaseDirectory) {
            this.BASE_DIRECTORY_NAME = "";
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TomcatModelData data = new TomcatModelData();
        data.setDeployTomcatApps(this.DEPLOY_TOMCAT_APPS);
        data.setBaseDirectoryName(this.BASE_DIRECTORY_NAME);
        data.setHttpPort(this.HTTP_PORT);
        data.setHttpsPort(this.HTTPS_PORT);
        data.setJndiPort(this.JNDI_PORT);
        data.setAjpPort(this.AJP_PORT);
        data.setPreserveSessions(this.PRESERVE_SESSIONS);
        XmlSerializer.serializeInto((Object)data, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new TomcatLocalRunConfigurationEditor();
    }

    public boolean isSourceLocalPort() {
        return this.HTTP_PORT == 0;
    }

    public int getLocalPort() {
        Integer port = this.getHttpPort();
        return port == null ? this.getDefaultPort() : port.intValue();
    }

    public Integer getHttpPort() {
        if (!this.isSourceLocalPort()) {
            return this.HTTP_PORT;
        }
        try {
            TomcatPersistentDataWrapper dataWrapper = this.createPersistentDataWrapper();
            if (dataWrapper.hasSourceLocalPort()) {
                return dataWrapper.getSourceLocalPort();
            }
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return null;
    }

    public void setHttpPort(int port) {
        this.HTTP_PORT = port;
        try {
            TomcatPersistentDataWrapper dataWrapper = this.createPersistentDataWrapper();
            if (dataWrapper.hasSourceLocalPort() && port == dataWrapper.getSourceLocalPort()) {
                this.HTTP_PORT = 0;
            }
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
    }

    public boolean isDetectableLocalPort() {
        return false;
    }

    public boolean isDetectableServerPort() {
        return false;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.isVersion8OrHigher()) {
            if (!SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                this.checkHasJdk();
            }
            this.checkJdkAtLeast7();
        }
        super.checkConfiguration();
        TomcatServerXmlWrapper serverXmlWrapper = new TomcatServerXmlWrapper(this.getSourceBaseDirectoryPath());
        serverXmlWrapper.checkHttpConnectorsAmount();
        if (this.HTTPS_PORT != 0) {
            serverXmlWrapper.checkHttpsConnectorsAmount();
        }
        if (this.AJP_PORT != 0) {
            serverXmlWrapper.checkAjpConnectorsAmount();
        }
    }

    protected String getJdkRequiredMessage() {
        return this.getJdkTooOldMessage(JavaSdkVersion.JDK_1_7.getDescription());
    }

    private String createLogFilePath(@NonNls String filename) {
        return FileUtil.toSystemDependentName((String)(TomcatUtil.getLogsDirPath(this.getBaseDirectoryPath()) + "/" + filename + ".*"));
    }

    protected String getLogFilePath(String home) {
        return this.createLogFilePath("localhost");
    }

    @Override
    protected int getJndiPort() {
        return this.JNDI_PORT;
    }

    @Nullable
    public File getAccessFile() {
        return this.myAccessFile;
    }

    @Nullable
    public File getPasswordFile() {
        return this.myPasswordFile;
    }

    public PositionManager createPositionManager(DebugProcess process, JavaeeFacet[] scopeFacetsWithIncluded) {
        if (this.isVersion5OrHigher()) {
            return super.createPositionManager(process, scopeFacetsWithIncluded);
        }
        return new Tomcat40PositionManager(process, TomcatUtil.getGeneratedFilesPath(this), scopeFacetsWithIncluded);
    }

    private void prepareServer() throws ExecutionException {
        try {
            int securedLocalPort;
            TomcatServerXmlWrapper workServerXml;
            Element localHost;
            String appBase;
            String baseDirectoryPath = this.getBaseDirectoryPath();
            File baseDirectory = new File(baseDirectoryPath);
            File logsDir = new File(TomcatUtil.getLogsDirPath(baseDirectoryPath));
            List sessionFiles = this.PRESERVE_SESSIONS && baseDirectory.isDirectory() ? FileUtil.findFilesByMask((Pattern)SESSIONS_FILENAME_PATTERN, (File)baseDirectory) : Collections.emptyList();
            FileUtil.processFilesRecursively((File)baseDirectory, file -> {
                if (FileUtil.compareFiles((File)file, (File)baseDirectory) == 0 || logsDir.exists() && FileUtil.isAncestor((File)logsDir, (File)file, (boolean)false)) {
                    return true;
                }
                for (File sessionFile : sessionFiles) {
                    if (!FileUtil.isAncestor((File)file, (File)sessionFile, (boolean)false)) continue;
                    return true;
                }
                FileUtil.delete((File)file);
                return true;
            });
            String sourceBaseDirectoryPath = this.getSourceBaseDirectoryPath();
            File sourceBase = new File(TomcatUtil.baseConfigDir(sourceBaseDirectoryPath));
            File workBase = new File(TomcatUtil.baseConfigDir(baseDirectoryPath));
            try {
                File setEnvFile;
                FileUtil.copyDir((File)sourceBase, (File)workBase, file -> !FileTypeManager.getInstance().isFileIgnored(file.getName()));
                if (!this.getHomeDirectory().equals(sourceBaseDirectoryPath) && (setEnvFile = TomcatUtil.getSetEnvFile(sourceBaseDirectoryPath)).exists()) {
                    FileUtil.copy((File)setEnvFile, (File)TomcatUtil.getSetEnvFile(baseDirectoryPath));
                }
                LOG.debug("Logs dir created: " + logsDir.mkdir());
            }
            catch (IOException e) {
                throw new ExecutionException(TomcatBundle.message("message.text.error.copying.configuration.files.from.0.to.1.because.of.2", sourceBase.getPath(), workBase.getPath(), e.getMessage()));
            }
            TomcatLocalModel.patchCatalinaProperties(new File(workBase, "catalina.properties"), sourceBaseDirectoryPath);
            if (!this.DEPLOY_TOMCAT_APPS) {
                TomcatContexts contexts = new TomcatContexts(this, baseDirectoryPath);
                for (TomcatContextItem contextItem : contexts.getItems()) {
                    if (!this.isVersion5OrHigher() && MANAGER_CONTEXT_PATH.equals(contextItem.getPath())) continue;
                    contextItem.remove();
                }
            }
            if ((appBase = (localHost = (workServerXml = new TomcatServerXmlWrapper(baseDirectoryPath)).findLocalHost()).getAttributeValue("appBase")) == null) {
                appBase = "";
            }
            if (!FileUtil.isAbsolute((String)appBase)) {
                appBase = new File(sourceBaseDirectoryPath, appBase).getAbsolutePath();
            }
            localHost.setAttribute("appBase", appBase);
            localHost.setAttribute(AUTO_DEPLOY_ATTR, Boolean.TRUE.toString());
            localHost.setAttribute(UNPACK_WARS_ATTR, Boolean.TRUE.toString());
            localHost.setAttribute(DEPLOY_ON_STARTUP_ATTR, Boolean.FALSE.toString());
            if (!this.DEPLOY_TOMCAT_APPS) {
                boolean supportDeployIgnore;
                try {
                    supportDeployIgnore = this.isVersionHigher6032();
                }
                catch (IOException e) {
                    throw new ExecutionException((Throwable)e);
                }
                if (supportDeployIgnore) {
                    localHost.setAttribute("deployIgnore", "^(?!(manager)|(tomee)$).*");
                }
            }
            if (!this.isSourceLocalPort()) {
                workServerXml.setHttpPort(this.HTTP_PORT);
            }
            if ((securedLocalPort = this.HTTPS_PORT) != 0) {
                workServerXml.setHttpsPort(securedLocalPort);
            }
            FreePortsProvider freePortsProvider = new FreePortsProvider();
            int shutdownPort = workServerXml.getShutdownPort();
            if (!TomcatLocalModel.isPortFree(shutdownPort)) {
                shutdownPort = freePortsProvider.getFreePorts()[0];
                workServerXml.setShutdownPort(shutdownPort);
            }
            if (this.AJP_PORT == 0) {
                Integer ajpPort = workServerXml.getAjpPort();
                if (ajpPort != null && !TomcatLocalModel.isPortFree(ajpPort)) {
                    ajpPort = freePortsProvider.getFreePorts()[1];
                    workServerXml.setAjpPort(ajpPort);
                }
            } else {
                workServerXml.setAjpPort(this.AJP_PORT);
            }
            workServerXml.save();
            File tomcatUsers = new File(workBase, TOMCAT_USERS_XML);
            if (tomcatUsers.exists() && !this.isVersion5OrHigher()) {
                Tomcat4Deployer.addManagerUser(tomcatUsers);
            }
            TomcatUtil.configureWebXml(this);
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void addContexts() throws ExecutionException {
        if (!this.isVersion5OrHigher()) {
            for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
                TomcatAdminLocalServerImpl.addApplicationContext((TomcatModuleDeploymentModel)deploymentModel);
            }
        }
    }

    private static boolean isPortFree(int port) {
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
            try {
                socket.close();
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
            return false;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                try {
                    serverSocket.close();
                }
                catch (IOException e2) {
                    LOG.debug((Throwable)e2);
                }
            }
            catch (IOException e3) {
                LOG.debug((Throwable)e3);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchCatalinaProperties(File file, String catalinaBasePath) {
        if (!file.exists()) {
            return;
        }
        try {
            File oldFile = new File(file.getAbsolutePath() + ".0");
            FileUtil.rename((File)file, (File)oldFile);
            BufferedReader input = new BufferedReader(new FileReader(oldFile));
            PrintWriter output = new PrintWriter(file);
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    output.println(StringUtil.replace((String)line, (String)"${catalina.base}", (String)FileUtil.toSystemIndependentName((String)catalinaBasePath)));
                }
            }
            finally {
                output.close();
                input.close();
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/tomcat/server/TomcatLocalModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemBaseDirectoryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLogFiles";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private abstract class TomcatLogFileFactory
    extends JavaeeServerModel.LogFileFactory {
        public TomcatLogFileFactory(boolean enabled) {
            super(enabled);
        }

        public TomcatLogFileFactory() {
            super(false);
        }

        public LogFileOptions createOptions(PredefinedLogFile file) {
            if (TomcatLocalModel.TOMCAT_LOCALHOST_ACCESS_LOG_ID.equals(file.getId()) && !TomcatLocalModel.this.isVersion7OrHigher()) {
                return null;
            }
            return super.createOptions(file);
        }

        protected String getPath() {
            return TomcatLocalModel.this.createLogFilePath(this.getFilename());
        }

        protected abstract String getFilename();
    }

    private static class FreePortsProvider {
        private int[] myFreePorts = null;

        private FreePortsProvider() {
        }

        public int[] getFreePorts() throws ExecutionException {
            if (this.myFreePorts == null) {
                try {
                    this.myFreePorts = NetUtils.findAvailableSocketPorts((int)2);
                }
                catch (IOException e) {
                    throw new ExecutionException("Unable to find free ports", (Throwable)e);
                }
            }
            return this.myFreePorts;
        }
    }

    public static class TomcatModelData {
        private boolean myDeployTomcatApps = false;
        private String myBaseDirectoryName = "";
        private int myHttpPort = 0;
        private int myHttpsPort = 0;
        private int myJndiPort = 1099;
        private int myAjpPort = 0;
        private boolean myPreserveSessions = false;

        @OptionTag(value="DEPLOY_TOMCAT_APPS")
        public boolean isDeployTomcatApps() {
            return this.myDeployTomcatApps;
        }

        public void setDeployTomcatApps(boolean deployTomcatApps) {
            this.myDeployTomcatApps = deployTomcatApps;
        }

        @OptionTag(value="BASE_DIRECTORY_NAME")
        public String getBaseDirectoryName() {
            return this.myBaseDirectoryName;
        }

        public void setBaseDirectoryName(String baseDirectoryName) {
            this.myBaseDirectoryName = baseDirectoryName;
        }

        @OptionTag(value="HTTP_PORT")
        public int getHttpPort() {
            return this.myHttpPort;
        }

        public void setHttpPort(int httpPort) {
            this.myHttpPort = httpPort;
        }

        @OptionTag(value="HTTPS_PORT")
        public int getHttpsPort() {
            return this.myHttpsPort;
        }

        public void setHttpsPort(int httpsPort) {
            this.myHttpsPort = httpsPort;
        }

        @OptionTag(value="PRESERVE_SESSIONS")
        public boolean isPreserveSessions() {
            return this.myPreserveSessions;
        }

        public void setPreserveSessions(boolean preserveSessions) {
            this.myPreserveSessions = preserveSessions;
        }

        @OptionTag(value="JNDI_PORT")
        public int getJndiPort() {
            return this.myJndiPort;
        }

        public void setJndiPort(int jndiPort) {
            this.myJndiPort = jndiPort;
        }

        @OptionTag(value="AJP_PORT")
        public int getAjpPort() {
            return this.myAjpPort;
        }

        public void setAjpPort(int ajpPort) {
            this.myAjpPort = ajpPort;
        }
    }
}

