/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CfmlExpressionTypeCalculator {
    public static final CfmlExpressionTypeCalculator PLUS_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
            PsiType rightType;
            if (leftOperand == null) {
                1.$$$reportNull$$$0(0);
            }
            if (rightOperand == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((rightType = rightOperand.getPsiType()) == null || rightType.equalsToText("java.lang.String")) {
                return rightType;
            }
            PsiType leftType = leftOperand.getPsiType();
            if (leftType == null || leftType.equalsToText("java.lang.String")) {
                return leftType;
            }
            return CfmlExpressionTypeCalculator.checkAndReturnNumeric(leftOperand, rightOperand);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftOperand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightOperand";
                    break;
                }
            }
            objectArray[1] = "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$1";
            objectArray[2] = "calculateBinary";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final CfmlExpressionTypeCalculator MINUS_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateUnary(@NotNull CfmlExpression operand) {
            PsiType type;
            if (operand == null) {
                2.$$$reportNull$$$0(0);
            }
            return (type = operand.getPsiType()) != null && TypeConversionUtil.isNumericType((PsiType)type) ? type : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$2", "calculateUnary"));
        }
    };
    public static final CfmlExpressionTypeCalculator MULTIPLICATIVE_CALCULATOR = new CfmlExpressionTypeCalculator(){};
    public static final CfmlExpressionTypeCalculator CONCATINATION_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
            if (leftOperand == null) {
                4.$$$reportNull$$$0(0);
            }
            if (rightOperand == null) {
                4.$$$reportNull$$$0(1);
            }
            return CfmlPsiUtil.getTypeByName("java.lang.String", leftOperand.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftOperand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightOperand";
                    break;
                }
            }
            objectArray[1] = "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$4";
            objectArray[2] = "calculateBinary";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final CfmlExpressionTypeCalculator BOOLEAN_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
            if (leftOperand == null) {
                5.$$$reportNull$$$0(0);
            }
            if (rightOperand == null) {
                5.$$$reportNull$$$0(1);
            }
            return PsiType.BOOLEAN;
        }

        @Override
        public PsiType calculateUnary(@NotNull CfmlExpression operand) {
            if (operand == null) {
                5.$$$reportNull$$$0(2);
            }
            return PsiType.BOOLEAN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftOperand";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightOperand";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$5";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateBinary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateUnary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private CfmlExpressionTypeCalculator() {
    }

    @Nullable
    public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
        if (leftOperand == null) {
            CfmlExpressionTypeCalculator.$$$reportNull$$$0(0);
        }
        if (rightOperand == null) {
            CfmlExpressionTypeCalculator.$$$reportNull$$$0(1);
        }
        return CfmlExpressionTypeCalculator.checkAndReturnNumeric(leftOperand, rightOperand);
    }

    @Nullable
    public PsiType calculateUnary(@NotNull CfmlExpression expression) {
        if (expression == null) {
            CfmlExpressionTypeCalculator.$$$reportNull$$$0(2);
        }
        throw new AssertionError(this);
    }

    @Nullable
    private static PsiType checkAndReturnNumeric(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
        PsiType rightType;
        if (leftOperand == null) {
            CfmlExpressionTypeCalculator.$$$reportNull$$$0(3);
        }
        if (rightOperand == null) {
            CfmlExpressionTypeCalculator.$$$reportNull$$$0(4);
        }
        if ((rightType = rightOperand.getPsiType()) == null) {
            return null;
        }
        PsiType leftType = leftOperand.getPsiType();
        if (leftType == null) {
            return null;
        }
        if (TypeConversionUtil.isNumericType((PsiType)leftType) && TypeConversionUtil.isNumericType((PsiType)rightType)) {
            PsiClassType boxedType = ((PsiPrimitiveType)TypeConversionUtil.unboxAndBalanceTypes((PsiType)leftType, (PsiType)rightType)).getBoxedType(leftOperand.getManager(), leftOperand.getResolveScope());
            return boxedType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateBinary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateUnary";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndReturnNumeric";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

