/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.UI.inspections.CfmlInspectionBase;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.info.CfmlLangInfo;
import com.intellij.coldFusion.model.psi.CfmlArgumentNameReference;
import com.intellij.coldFusion.model.psi.CfmlAssignmentExpression;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlReference;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CfmlReferenceInspection
extends CfmlInspectionBase {
    private static final Map<String, Condition<PsiElement>> myDictionary = new HashMap();

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            CfmlReferenceInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        CfmlAssignmentExpression assignment;
        CfmlVariable var;
        Condition<PsiElement> psiElementCondition;
        String functionName;
        if (!(element instanceof CfmlReference)) {
            return;
        }
        CfmlReference ref = (CfmlReference)element;
        if (CfmlUtil.isPredefinedFunction(ref.getText(), element.getProject())) {
            return;
        }
        if (ref instanceof CfmlArgumentNameReference && CfmlUtil.isPredefinedFunction(functionName = ((CfmlArgumentNameReference)ref).getFunctionName(), element.getProject())) {
            return;
        }
        String key = ref.getText().toLowerCase();
        if (myDictionary.containsKey(key) && (psiElementCondition = myDictionary.get(key)).value((Object)element)) {
            return;
        }
        PsiElement mostDescentReferenceParent = element;
        while (mostDescentReferenceParent.getParent() instanceof CfmlReference) {
            mostDescentReferenceParent = mostDescentReferenceParent.getParent();
        }
        if (CfmlLangInfo.getInstance(element.getProject()).getPredefinedVariables().containsKey(mostDescentReferenceParent.getText().toLowerCase())) {
            return;
        }
        if (ref instanceof CfmlReferenceExpression && CfmlUtil.isPredefinedTagVariables((CfmlReferenceExpression)ref, element.getProject())) {
            return;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof CfmlAssignmentExpression && (var = (assignment = (CfmlAssignmentExpression)parent).getAssignedVariable()) != null && assignment.getAssignedVariableElement() == ref) {
            return;
        }
        if (ref.multiResolve(false).length == 0) {
            String message = "Can't resolve";
            holder.registerProblem((PsiReference)ref, "Can't resolve", ProblemHighlightType.WEAK_WARNING);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CfmlBundle.message("cfml.references.inspection", new Object[0]);
        if (string == null) {
            CfmlReferenceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CfmlReferenceInspection" == null) {
            CfmlReferenceInspection.$$$reportNull$$$0(2);
        }
        return "CfmlReferenceInspection";
    }

    static {
        myDictionary.put("arguments", (Condition<PsiElement>)((Condition)psiElement -> {
            CfmlFunction parentOfType = (CfmlFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CfmlFunction.class);
            return parentOfType != null;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/coldFusion/UI/inspections/CfmlReferenceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

