/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.typedHandlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CfmlEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            CfmlEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CfmlEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            CfmlEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            CfmlEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            CfmlEnterHandler.$$$reportNull$$$0(4);
        }
        if (file.getLanguage() != CfmlLanguage.INSTANCE) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (file instanceof CfmlFile && CfmlEnterHandler.isBetweenCfmlTags(file, editor, (Integer)caretOffset.get())) {
            originalHandler.execute(editor, dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        if (this.isAfterAndBeforeCurlyBracket(editor, (Integer)caretOffset.get())) {
            originalHandler.execute(editor, dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private boolean isAfterAndBeforeCurlyBracket(Editor editor, int offset) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        return offset > 0 && chars.charAt(offset - 1) == '{' && offset < chars.length() && chars.charAt(offset) == '}';
    }

    private static boolean isBetweenCfmlTags(PsiFile file, Editor editor, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '>') {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        if (iterator.getTokenType() != CfmlTokenTypes.R_ANGLEBRACKET) {
            return false;
        }
        iterator.retreat();
        int retrieveCount = 1;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == CfmlTokenTypes.LSLASH_ANGLEBRACKET) {
                return false;
            }
            if (tokenType == CfmlTokenTypes.OPENER) break;
            ++retrieveCount;
            iterator.retreat();
        }
        for (int i = 0; i < retrieveCount; ++i) {
            iterator.advance();
        }
        iterator.advance();
        return !iterator.atEnd() && iterator.getTokenType() == CfmlTokenTypes.LSLASH_ANGLEBRACKET;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlEnterHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

