/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.coldFusion.UI.editorActions.completionProviders.CfmlMethodInsertHandler;
import com.intellij.coldFusion.model.info.CfmlFunctionDescription;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlParameter;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.coldFusion.model.psi.impl.CfmlNamedAttributeImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class CfmlLookUpItemUtil
implements PlatformIcons {
    public static LookupElement functionDescriptionToLookupItem(final CfmlFunctionDescription functionDescription) {
        String name = "" + functionDescription.getName();
        String typeText = functionDescription.getReturnType();
        String tailText = "(" + functionDescription.getParametersListPresentableText() + ")";
        return LookupElementBuilder.create((String)name).withTypeText(typeText).withIcon(METHOD_ICON).withInsertHandler((InsertHandler)new ParenthesesInsertHandler<LookupElement>(){

            protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
                return functionDescription.getParameters().size() != 0;
            }

            public void handleInsert(InsertionContext context, LookupElement item) {
                super.handleInsert(context, item);
                new ShowParameterInfoHandler().invoke(context.getProject(), context.getEditor(), context.getFile());
            }
        }).withTailText(tailText).withCaseSensitivity(false);
    }

    public static LookupElement namedElementToLookupItem(PsiNamedElement element, @Nullable String prefix) {
        if (element instanceof LookupElement) {
            return (LookupElement)element;
        }
        if (element instanceof PsiClass) {
            return JavaLookupElementBuilder.forClass((PsiClass)((PsiClass)element));
        }
        if (element instanceof PsiMethod) {
            if (((PsiMethod)element).isConstructor()) {
                return JavaLookupElementBuilder.forMethod((PsiMethod)((PsiMethod)element), (String)"init", (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
            }
            return JavaLookupElementBuilder.forMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        if (element instanceof PsiVariable) {
            return JavaLookupElementBuilder.forField((PsiField)((PsiField)element));
        }
        if (element instanceof PsiType) {
            return PsiTypeLookupItem.createLookupItem((PsiType)((PsiType)element), null);
        }
        String name = "" + element.getName();
        String typeText = null;
        String tailText = null;
        if (element instanceof CfmlFunction) {
            tailText = "(" + ((CfmlFunction)element).getParametersAsString() + ")";
            PsiType returnType = ((CfmlFunction)element).getReturnType();
            typeText = returnType != null ? returnType.getCanonicalText() : null;
        } else if (element instanceof CfmlNamedAttributeImpl && element.getParent() instanceof CfmlFunction) {
            CfmlFunction cfmlFunction = (CfmlFunction)element.getParent();
            tailText = "(" + cfmlFunction.getParametersAsString() + ")";
            PsiType returnType = cfmlFunction.getReturnType();
            typeText = returnType != null ? returnType.getCanonicalText() : null;
        } else if (element instanceof CfmlVariable) {
            PsiType type = ((CfmlVariable)element).getPsiType();
            if (type != null) {
                typeText = type.getPresentableText();
            }
            name = ((CfmlVariable)element).getlookUpString();
        } else if (element instanceof PsiDirectory) {
            name = element.getName();
            tailText = ".";
        }
        if (prefix != null && prefix.length() != 0 && !name.toLowerCase().startsWith(prefix.toLowerCase())) {
            name = prefix + "." + name;
        }
        return LookupElementBuilder.create((Object)element, (String)name).withTypeText(typeText).withIcon(CfmlLookUpItemUtil.getIcon((PsiElement)element)).withInsertHandler(CfmlLookUpItemUtil.getInsertHandler(element)).withTailText(tailText).withCaseSensitivity(false);
    }

    @Nullable
    private static InsertHandler<LookupElement> getInsertHandler(PsiNamedElement element) {
        if (CfmlPsiUtil.isFunctionDefinition(element)) {
            return CfmlMethodInsertHandler.getInstance();
        }
        return null;
    }

    @Nullable
    private static Icon getIcon(PsiElement element) {
        if (CfmlPsiUtil.isFunctionDefinition(element)) {
            return METHOD_ICON;
        }
        if (element instanceof CfmlParameter) {
            return PARAMETER_ICON;
        }
        if (element instanceof CfmlVariable) {
            return VARIABLE_ICON;
        }
        if (element instanceof CfmlComponent) {
            if (((CfmlComponent)element).isInterface()) {
                return INTERFACE_ICON;
            }
            return CLASS_ICON;
        }
        return null;
    }

    public static CfmlFunctionDescription getFunctionDescription(CfmlFunction function) {
        CfmlParameter[] params;
        PsiType returnType = function.getReturnType();
        CfmlFunctionDescription functionInfo = new CfmlFunctionDescription(function.getName(), returnType != null ? returnType.getCanonicalText() : null);
        for (CfmlParameter param : params = function.getParameters()) {
            functionInfo.addParameter(new CfmlFunctionDescription.CfmlParameterDescription(param.getName(), param.getType(), param.isRequired()));
        }
        return functionInfo;
    }
}

