/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.groovy.resolve.noncode;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberCommonClassNames;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberUtil;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class CustomWorldContributor
extends NonCodeMembersContributor {
    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GrClosableBlock closureContainer;
        if (qualifierType == null) {
            CustomWorldContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            CustomWorldContributor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            CustomWorldContributor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            CustomWorldContributor.$$$reportNull$$$0(3);
        }
        if (place instanceof GrReferenceExpression && ((GrReferenceExpression)place).getQualifier() == null && qualifierType.equalsToText("groovy.lang.Closure") && (closureContainer = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class, (boolean)true, (Class[])new Class[]{GrMember.class})) != null) {
            PsiElement parent = closureContainer.getParent();
            if (parent instanceof GrArgumentList && CustomWorldContributor.isLastArg((GrArgumentList)parent, closureContainer)) {
                parent = parent.getParent();
            }
            if (parent instanceof GrMethodCall && (GrCucumberUtil.isStepDefinition(parent) || GrCucumberUtil.isHook((GrMethodCall)parent))) {
                CustomWorldContributor.doProcessDynamicMethods(processor, place, state, parent.getContainingFile());
            }
        }
    }

    private static void doProcessDynamicMethods(@NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state, PsiFile stepFile) {
        if (processor == null) {
            CustomWorldContributor.$$$reportNull$$$0(4);
        }
        if (place == null) {
            CustomWorldContributor.$$$reportNull$$$0(5);
        }
        if (state == null) {
            CustomWorldContributor.$$$reportNull$$$0(6);
        }
        if (stepFile instanceof GroovyFile) {
            PsiType worldType = CustomWorldContributor.getWorldType((GroovyFile)stepFile);
            if (worldType != null) {
                ResolveUtil.processAllDeclarations((PsiType)worldType, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)place);
            } else {
                PsiFile[] files;
                GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)stepFile.getResolveScope(), (FileType[])GroovyFileType.getGroovyEnabledFileTypes());
                for (PsiFile file : files = CacheManager.SERVICE.getInstance((Project)place.getProject()).getFilesWithWord("World", (short)1, scope, true)) {
                    PsiType type;
                    if (!(file instanceof GroovyFile) || (type = CustomWorldContributor.getWorldType((GroovyFile)file)) == null || ResolveUtil.processAllDeclarations((PsiType)type, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)place)) continue;
                    return;
                }
            }
        }
    }

    @Nullable
    private static PsiType getWorldType(@NotNull GroovyFile stepFile) {
        if (stepFile == null) {
            CustomWorldContributor.$$$reportNull$$$0(7);
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)stepFile, () -> {
            if (stepFile == null) {
                CustomWorldContributor.$$$reportNull$$$0(12);
            }
            for (GrStatement statement : stepFile.getStatements()) {
                if (!(statement instanceof GrMethodCall) || !CustomWorldContributor.isWorldDeclaration((GrMethodCall)statement)) continue;
                GrClosableBlock closure = CustomWorldContributor.getClosureArg((GrMethodCall)statement);
                return CachedValueProvider.Result.create((Object)(closure == null ? null : closure.getReturnType()), (Object[])new Object[]{stepFile});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{stepFile});
        });
    }

    @Nullable
    private static GrClosableBlock getClosureArg(@NotNull GrMethodCall methodCall) {
        GrClosableBlock[] closures;
        if (methodCall == null) {
            CustomWorldContributor.$$$reportNull$$$0(8);
        }
        if ((closures = methodCall.getClosureArguments()).length == 1) {
            return closures[0];
        }
        if (closures.length > 1) {
            return null;
        }
        Object[] args = methodCall.getExpressionArguments();
        if (args.length == 0) {
            return null;
        }
        GrExpression last = (GrExpression)DefaultGroovyMethods.last((Object[])args);
        if (last instanceof GrClosableBlock) {
            return (GrClosableBlock)last;
        }
        return null;
    }

    private static boolean isWorldDeclaration(@NotNull GrMethodCall methodCall) {
        GrExpression invoked;
        if (methodCall == null) {
            CustomWorldContributor.$$$reportNull$$$0(9);
        }
        if ((invoked = methodCall.getInvokedExpression()) instanceof GrReferenceExpression) {
            PsiMethod method = methodCall.resolveMethod();
            PsiClass clazz = method == null ? null : method.getContainingClass();
            String qname = clazz == null ? null : clazz.getQualifiedName();
            return method != null && "World".equals(method.getName()) && GrCucumberCommonClassNames.isHookClassName(qname);
        }
        return false;
    }

    private static boolean isLastArg(@NotNull GrArgumentList list, @NotNull GrClosableBlock block) {
        GrExpression[] exprs;
        if (list == null) {
            CustomWorldContributor.$$$reportNull$$$0(10);
        }
        if (block == null) {
            CustomWorldContributor.$$$reportNull$$$0(11);
        }
        return (exprs = list.getExpressionArguments()).length > 0 && exprs[exprs.length - 1] == block;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doProcessDynamicMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorldType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getClosureArg";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isWorldDeclaration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isLastArg";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getWorldType$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

