/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.fileEditor;

import com.intellij.jboss.jpdl.graph.JpdlDataModel;
import com.intellij.jboss.jpdl.graph.JpdlEdge;
import com.intellij.jboss.jpdl.graph.JpdlNode;
import com.intellij.jboss.jpdl.graph.JpdlPresentationModel;
import com.intellij.jboss.jpdl.graph.dnd.JpdlDnDSupport;
import com.intellij.jboss.jpdl.model.xml.JpdlNamedActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.dnd.GraphDnDSupport;
import com.intellij.openapi.graph.builder.dnd.GraphDnDUtils;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.geom.YRectangle;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomEventAdapter;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JpdlDesignerComponent
extends JPanel
implements DataProvider,
Disposable {
    @NonNls
    public static final String JPDL_DESIGNER_COMPONENT = "JPDL_DESIGNER_COMPONENT";
    @NonNls
    private static final String JPDL_DESIGNER_NAVIGATION_PROVIDER_NAME = "JPDL_DESIGNER_NAVIGATION_PROVIDER_NAME";
    @NonNls
    private final SeamProcessDesignerNavigationProvider myNavigationProvider = new SeamProcessDesignerNavigationProvider();
    private final GraphBuilder<JpdlNode, JpdlEdge> myBuilder;
    private final XmlFile myXmlFile;
    private final JpdlDataModel myDataModel;

    public JpdlDesignerComponent(XmlFile xmlFile) {
        this.myXmlFile = xmlFile;
        Project project = xmlFile.getProject();
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
        this.myDataModel = new JpdlDataModel(xmlFile);
        JpdlPresentationModel presentationModel = new JpdlPresentationModel(graph, project);
        this.myBuilder = GraphBuilderFactory.getInstance((Project)project).createGraphBuilder(graph, view, (GraphDataModel)this.myDataModel, (GraphPresentationModel)presentationModel);
        GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)new MyDataProvider(this.myBuilder));
        Splitter splitter = new Splitter(false, 0.85f);
        this.setLayout(new BorderLayout());
        final SimpleDnDPanel simpleDnDPanel = GraphDnDUtils.createDnDActions((Project)project, this.myBuilder, (GraphDnDSupport)new JpdlDnDSupport(this.myDataModel));
        JComponent graphComponent = this.myBuilder.getView().getJComponent();
        splitter.setSecondComponent((JComponent)simpleDnDPanel.getTree());
        splitter.setFirstComponent(graphComponent);
        splitter.setDividerWidth(5);
        this.add((Component)this.createToolbarPanel(), "North");
        this.add((Component)splitter, "Center");
        Disposer.register((Disposable)this, this.myBuilder);
        this.myBuilder.initialize();
        DomManager.getDomManager((Project)this.myBuilder.getProject()).addDomEventListener((DomEventListener)new DomEventAdapter(){

            public void eventOccured(DomEvent event) {
                if (JpdlDesignerComponent.this.isShowing()) {
                    simpleDnDPanel.getBuilder().updateFromRoot();
                    JpdlDesignerComponent.this.myBuilder.queueUpdate();
                }
            }
        }, (Disposable)this);
    }

    private JComponent createToolbarPanel() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)GraphViewUtil.getBasicToolbar(this.myBuilder));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JdpiDesigner", (ActionGroup)actions, true);
        return actionToolbar.getComponent();
    }

    public List<DomElement> getSelectedDomElements() {
        ArrayList<DomElement> selected = new ArrayList<DomElement>();
        Graph2D graph = this.myBuilder.getGraph();
        for (Node n : graph.getNodeArray()) {
            JpdlNode nodeObject;
            if (!graph.isSelected(n) || (nodeObject = (JpdlNode)this.myBuilder.getNodeObject(n)) == null) continue;
            ContainerUtil.addIfNotNull(selected, nodeObject.getIdentifyingElement());
        }
        return selected;
    }

    public void setSelectedDomElement(DomElement domElement) {
        if (domElement == null) {
            return;
        }
        JpdlNamedActivity activity = (JpdlNamedActivity)domElement.getParentOfType(JpdlNamedActivity.class, false);
        Node selectedNode = this.findNode(activity);
        if (selectedNode != null) {
            Graph2D graph = this.myBuilder.getGraph();
            for (Node n : graph.getNodeArray()) {
                boolean selected = n.equals(selectedNode);
                graph.setSelected(n, selected);
                if (!selected) continue;
                YRectangle yRectangle = graph.getRectangle(n);
                if (this.myBuilder.getView().getVisibleRect().contains(new Rectangle((int)yRectangle.getX(), (int)yRectangle.getY(), (int)yRectangle.getWidth(), (int)yRectangle.getHeight()))) continue;
                this.myBuilder.getView().setCenter(graph.getX(n), graph.getY(n));
            }
        }
        this.myBuilder.getView().updateView();
    }

    @Nullable
    private Node findNode(@Nullable JpdlNamedActivity activity) {
        if (activity == null) {
            return null;
        }
        Collection nodeObjects = this.myBuilder.getNodeObjects();
        for (JpdlNode jpdlNode : nodeObjects) {
            if (!activity.equals(jpdlNode.getIdentifyingElement())) continue;
            return this.myBuilder.getNode((Object)jpdlNode);
        }
        return null;
    }

    public GraphBuilder getBuilder() {
        return this.myBuilder;
    }

    public Overview getOverview() {
        return GraphManager.getGraphManager().createOverview(this.myBuilder.getView());
    }

    public void dispose() {
    }

    public SeamProcessDesignerNavigationProvider getNavigationProvider() {
        return this.myNavigationProvider;
    }

    public XmlFile getXmlFile() {
        return this.myXmlFile;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (dataId.equals(JPDL_DESIGNER_COMPONENT)) {
            return this;
        }
        return null;
    }

    public JpdlDataModel getDataModel() {
        return this.myDataModel;
    }

    private class MyDataProvider
    implements DataProvider {
        private final Project myProject;
        private final Graph2D myGraph;

        public MyDataProvider(GraphBuilder<JpdlNode, JpdlEdge> builder) {
            this.myProject = builder.getProject();
            this.myGraph = builder.getGraph();
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (dataId.equals(DataConstants.PROJECT)) {
                return this.myProject;
            }
            if (dataId.equals("psi.Element")) {
                for (Node node : this.myGraph.getNodeArray()) {
                    JpdlNode jpdlNode;
                    if (!this.myGraph.getRealizer(node).isSelected() || (jpdlNode = (JpdlNode)JpdlDesignerComponent.this.myBuilder.getNodeObject(node)) == null) continue;
                    return jpdlNode.getIdentifyingElement().getXmlElement();
                }
            }
            return null;
        }
    }

    private class SeamProcessDesignerNavigationProvider
    extends DomElementNavigationProvider {
        private SeamProcessDesignerNavigationProvider() {
        }

        public String getProviderName() {
            return JpdlDesignerComponent.JPDL_DESIGNER_NAVIGATION_PROVIDER_NAME;
        }

        public void navigate(DomElement domElement, boolean requestFocus) {
            JpdlDesignerComponent.this.setSelectedDomElement(domElement);
        }

        public boolean canNavigate(DomElement domElement) {
            return domElement.isValid();
        }
    }
}

