/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.highlighting;

import com.intellij.jboss.jbpm.model.xml.bpmn20.TDataInput;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputOutputSpecification;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputSet;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.List;

public class DataInputIsReferencedInspection {
    private final DomElement myElement;
    private final DomElementAnnotationHolder myHolder;
    private final DomHighlightingHelper myHelper;

    public DataInputIsReferencedInspection(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        this.myElement = element;
        this.myHolder = holder;
        this.myHelper = helper;
    }

    public void check() {
        if (!this.myElement.isValid() || !((TDataInput)this.myElement).getId().isValid()) {
            return;
        }
        DomElement ioSpecDomElement = this.myElement.getParent();
        if (ioSpecDomElement == null || !TInputOutputSpecification.class.equals((Object)ioSpecDomElement.getDomElementType())) {
            return;
        }
        List<TInputSet> sets = ((TInputOutputSpecification)ioSpecDomElement).getInputSets();
        for (TInputSet set : sets) {
            List<GenericDomValue<TDataInput>> refses = set.getDataInputRefses();
            for (GenericDomValue<TDataInput> refse : refses) {
                TDataInput input;
                if (!refse.isValid() || (input = (TDataInput)refse.getValue()) == null || !input.equals(this.myElement)) continue;
                return;
            }
        }
        this.myHolder.createProblem(this.myElement, HighlightSeverity.ERROR, "Should be referenced by any dataInputRefs");
    }
}

